# 画面設計書 73-起動エラー

## 概要

本ドキュメントは、Jenkinsサーバーの起動が致命的なエラーにより失敗した場合に表示されるエラー画面の設計仕様を記述したものです。

### 本画面の処理概要

この画面はJenkinsサーバーの初期化処理中に致命的なエラー（Fatal Error）が発生した場合にユーザーへ表示されるエラー画面です。設定ファイルの破損、プラグインの互換性問題、必要なリソースへのアクセス失敗など、Jenkinsが正常に起動できない状態をユーザーと管理者に通知し、問題の診断に必要なスタックトレース情報を提供します。

**業務上の目的・背景**：JenkinsはCI/CDパイプラインの中核を担う重要なシステムであるため、起動失敗時には迅速な問題特定と復旧が求められます。この画面は、単にエラーが発生したことを通知するだけでなく、詳細なスタックトレースを表示することで、管理者が問題の原因を特定し、適切な対処を行うための情報を提供します。また、Groovyフックスクリプト（boot-failure）を実行する仕組みにより、カスタマイズされたエラー通知やログ出力が可能です。

**画面へのアクセス方法**：ユーザーがJenkins起動失敗後に任意のURLにアクセスした場合に自動的にこの画面が表示されます。直接的なナビゲーションリンクは存在せず、Jenkinsの初期化処理が失敗した際にServletContextに`HudsonFailedToLoad`オブジェクトが設定されることでアクセス時に表示されます。

**主要な操作・処理内容**：
1. 「Error」タイトルによるエラー状態の明示
2. 例外のスタックトレース全文の表示
3. 標準的なJenkinsレイアウト（ヘッダー、サイドパネル）の使用

**画面遷移**：
- 遷移元：なし（起動失敗時の初期状態）
- 遷移先：なし（Jenkinsが起動失敗状態のため遷移不可。問題を解決してJenkinsを再起動する必要がある）

**権限による表示制御**：この画面は認証・認可の処理が行われる前に表示されるため、権限による表示制御はありません。すべてのアクセスに対して同一の画面（スタックトレースを含む）が表示されます。セキュリティの観点から、本番環境では詳細なスタックトレースの公開に注意が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 70 | 初期化フレームワーク | 主機能 | Jenkins起動失敗時のエラー表示 |

## 画面種別

エラー画面（システム致命的エラー表示）

## URL/ルーティング

- URL: `/*`（Jenkins起動失敗状態では全URLでこの画面を表示）
- HTTPステータスコード: 500（Internal Server Error）

## 入出力項目

本画面は入力項目を持たない表示専用画面です。

| 項目名 | 入出力 | 説明 |
|--------|--------|------|
| なし | - | 入力項目なし |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| ページタイトル | テキスト | 「Jenkins」 |
| エラー見出し | h1テキスト | 「Error」 |
| スタックトレース | pre形式テキスト | `it.stackTraceString`から取得した例外のスタックトレース全文 |

## イベント仕様

### 1-画面表示処理

画面表示時に、`HudsonFailedToLoad`オブジェクトの`stackTraceString`プロパティから例外のスタックトレースを取得し、画面に表示します。

**処理フロー**:
1. リクエスト受信
2. `HudsonFailedToLoad`オブジェクトから例外情報を取得
3. 標準のJenkinsレイアウトでページを構成
4. スタックトレースをpre要素内に表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | 本画面ではデータベース操作は発生しない |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| pageTitle | タイトル | Jenkins | ページタイトルとして常時表示 |
| errorHeading | エラー | Error | エラー見出しとして常時表示 |
| stackTrace | 詳細情報 | （例外のスタックトレース） | 常時表示 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|----------|
| 起動エラー発生 | HudsonFailedToLoadオブジェクトがServletContextに設定され、この画面が表示される |
| boot-failureフック | JENKINS_HOMEにboot-failure.groovyスクリプトが存在する場合、カスタム処理を実行 |

## 備考

- この画面はJenkinsコアの初期化失敗処理と密接に連携しています
- `HudsonFailedToLoad`クラスは`BootFailure`クラスを継承しており、起動失敗の共通機能を提供します
- `failed-boot-attempts.txt`ファイルに起動失敗の履歴が記録されます
- Groovyフックスクリプト（`$JENKINS_HOME/boot-failure.groovy`）により、カスタムの通知処理やログ出力が可能です
- スタックトレースには機密情報（パス、設定値など）が含まれる可能性があるため、本番環境でのアクセス制限を検討すべきです

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、起動エラー画面の制御に使用されるモデルオブジェクトの継承階層を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BootFailure.java | `core/src/main/java/hudson/util/BootFailure.java` | 起動失敗の基底クラス。publish()メソッドでフックスクリプトを実行 |
| 1-2 | HudsonFailedToLoad.java | `core/src/main/java/hudson/util/HudsonFailedToLoad.java` | 起動エラー画面のモデルオブジェクト |

**読解のコツ**: `HudsonFailedToLoad`は`BootFailure`を継承しています。`BootFailure`クラスの`publish()`メソッドで、ServletContextへの設定とGroovyフックスクリプトの実行が行われます。

#### Step 2: エントリーポイントを理解する

リクエスト処理の起点を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | BootFailure.java | `core/src/main/java/hudson/util/BootFailure.java` | publish()メソッドでServletContextに設定 |

**主要処理フロー**:
1. **42-56行目**: publish()メソッドでログ出力、ServletContext設定、Groovyフック実行
2. **61-85行目**: loadAttempts()メソッドで起動試行履歴を読み込み
3. **94-96行目**: getBootFailureFile()でfailed-boot-attempts.txtファイルパスを取得

#### Step 3: ビューテンプレートを理解する

画面の実際のレンダリング処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.jelly | `core/src/main/resources/hudson/util/HudsonFailedToLoad/index.jelly` | Jellyテンプレートによる画面レンダリング |

**主要処理フロー**:
- **27行目**: HTTPステータスコード500の設定
- **28-29行目**: 標準レイアウトの使用（l:layout）
- **32行目**: 「Error」見出しの表示
- **33行目**: スタックトレースの表示（it.stackTraceString）

### プログラム呼び出し階層図

```
Jenkins初期化失敗
    │
    └─ HudsonFailedToLoad作成
           │
           └─ BootFailure.publish()
                  │
                  ├─ LOGGER.log(Level.SEVERE, ...)
                  │
                  ├─ WebApp.get(context).setApp(this)
                  │
                  └─ GroovyHookScript("boot-failure").run()
                         │
                         └─ (カスタム処理)

ServletContext.getAttribute("app")
    │
    └─ HudsonFailedToLoad
           │
           └─ index.jelly
                  │
                  ├─ l:layout (標準レイアウト)
                  │
                  └─ it.stackTraceString (エラー詳細)
```

### データフロー図

```
[入力]               [処理]                    [出力]

Throwable例外 ───▶ HudsonFailedToLoad      ───▶ HTTP 500レスポンス
                   │                             │
                   ├─ exception保持              ├─ index.jelly HTML
                   │                             │
                   └─ BootFailure               └─ スタックトレース
                      .publish()

[副作用]
    │
    ├─ failed-boot-attempts.txt 更新
    │
    └─ boot-failure.groovy 実行（存在時）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HudsonFailedToLoad.java | `core/src/main/java/hudson/util/HudsonFailedToLoad.java` | ソース | 起動エラー画面のモデルオブジェクト |
| BootFailure.java | `core/src/main/java/hudson/util/BootFailure.java` | ソース | 起動失敗の基底クラス（publish、フックスクリプト実行） |
| ErrorObject.java | `core/src/main/java/hudson/util/ErrorObject.java` | ソース | エラーオブジェクトの基底クラス（stackTraceString提供） |
| index.jelly | `core/src/main/resources/hudson/util/HudsonFailedToLoad/index.jelly` | テンプレート | 起動エラー画面のJellyテンプレート |
| WebAppMain.java | `core/src/main/java/hudson/WebAppMain.java` | ソース | 起動処理と失敗時のHudsonFailedToLoad設定 |
| boot-failure.groovy | `$JENKINS_HOME/boot-failure.groovy` | スクリプト | カスタムフックスクリプト（オプション） |
| failed-boot-attempts.txt | `$JENKINS_HOME/failed-boot-attempts.txt` | データ | 起動失敗履歴ファイル |
