# 画面設計書 75-CSP推奨設定

## 概要

本ドキュメントは、Content Security Policy（CSP）の推奨設定を表示し、CSP設定を有効化するよう管理者に促す画面の設計仕様を記述したものです。

### 本画面の処理概要

この画面はJenkinsのContent Security Policy（CSP）設定が未構成の場合に表示される管理者モニター画面です。CSPはWebセキュリティの重要な機能であり、XSS（クロスサイトスクリプティング）などの攻撃を防ぐために使用されます。この画面では、CSP設定の重要性を説明し、管理者がCSP設定を有効化するよう誘導します。

**業務上の目的・背景**：JenkinsはCI/CDパイプラインの中核を担うシステムであり、セキュリティが非常に重要です。CSPはブラウザレベルでのセキュリティ対策を提供し、悪意のあるスクリプトの実行を防止します。しかし、CSPは既存のプラグインやカスタムスクリプトと互換性の問題を引き起こす可能性があるため、デフォルトでは無効化されています。この管理者モニターは、CSP設定が未構成であることを検知し、管理者にセキュリティ設定の検討を促します。

**画面へのアクセス方法**：Jenkins管理画面（Manage Jenkins）の管理者モニターセクションに表示されます。また、直接URLアクセス（`/manage/administrativeMonitor/jenkins.security.csp.impl.CspRecommendation`）も可能です。

**主要な操作・処理内容**：
1. CSP設定の必要性と効果の説明を表示
2. 「Set up now」ボタンでセキュリティ設定画面のCSPセクションへ遷移
3. 「Cancel」ボタンで一時的に延期（管理画面へ戻る）
4. モニターを永続的に無効化（dismiss）する選択肢

**画面遷移**：
- 遷移元：Jenkins管理画面（28-Jenkins管理）
- 遷移先：
  - セキュリティ設定画面（/manage/configureSecurity/#contentSecurityPolicy）- 「Set up now」選択時
  - Jenkins管理画面（/manage/）- 「Cancel」または「dismiss」選択時

**権限による表示制御**：
- ADMINISTER権限：この画面にアクセスし、設定を変更可能
- 権限なし：管理者モニター自体が表示されないため、この画面にもアクセス不可

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | 認証（SecurityRealm） | 主機能 | Content Security Policy設定の表示 |
| 34 | 機密情報管理 | 補助機能 | セキュリティ設定の推奨 |

## 画面種別

管理者モニター画面（セキュリティ推奨）

## URL/ルーティング

- URL: `/manage/administrativeMonitor/jenkins.security.csp.impl.CspRecommendation`
- アクションエンドポイント: `POST /manage/administrativeMonitor/jenkins.security.csp.impl.CspRecommendation/act`

## 入出力項目

| 項目名 | 入出力 | 必須 | 型 | 説明 |
|--------|--------|------|-----|------|
| setup | 入力 | いいえ | hidden | 「Set up now」ボタン押下時に送信 |
| defer | 入力 | いいえ | hidden | 「Cancel」ボタン押下時に送信 |
| dismiss | 入力 | いいえ | hidden | モニター無効化時に送信 |
| more | 入力 | いいえ | hidden | 詳細表示要求時に送信 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| ページタイトル | テキスト | 「Content Security Policy configuration」 |
| アプリバータイトル | テキスト | 「Enabling Content Security Policy configuration」 |
| 説明段落1 | テキスト | CSP設定の説明（paragraph1） |
| 説明段落2 | テキスト | CSP設定の効果説明（paragraph2） |
| 説明段落3 | テキスト | CSP設定の注意事項（paragraph3） |
| Set up nowボタン | ボタン（プライマリ） | CSP設定を開始するボタン |
| Cancelボタン | ボタン（セカンダリ） | 一時的に延期するボタン |

## イベント仕様

### 1-CSP設定開始（Set up now）

「Set up now」ボタン押下時に、CSP設定を初期化し、セキュリティ設定画面へ遷移します。

**処理フロー**:
1. POSTリクエストを`/act`エンドポイントに送信（setup=true）
2. CspConfiguration.enforceをfalseに設定（初期化）
3. `/manage/configureSecurity/#contentSecurityPolicy`へリダイレクト

### 2-延期（Cancel）

「Cancel」ボタン押下時に、設定を行わずにJenkins管理画面へ戻ります。

**処理フロー**:
1. POSTリクエストを`/act`エンドポイントに送信（defer=true）
2. `/manage/`へリダイレクト

### 3-永続的無効化（Dismiss）

モニターを永続的に無効化します。

**処理フロー**:
1. POSTリクエストを`/act`エンドポイントに送信（dismiss=true）
2. AdministrativeMonitor.disable(true)を呼び出し
3. `/manage/`へリダイレクト

### 4-詳細表示（More）

詳細な説明を表示します。

**処理フロー**:
1. POSTリクエストを`/act`エンドポイントに送信（more=true）
2. `/manage/administrativeMonitor/jenkins.security.csp.impl.CspRecommendation`へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Set up now | - | ファイル更新 | CspConfiguration設定の初期化 |
| Dismiss | - | ファイル更新 | モニター無効化状態の保存 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| pageTitle | タイトル | Content Security Policy configuration | 常時表示 |
| appBarTitle | タイトル | Enabling Content Security Policy configuration | 常時表示 |
| paragraph1 | 説明 | （CSP設定の説明） | 常時表示 |
| paragraph2 | 説明 | （CSP設定の効果） | 常時表示 |
| paragraph3 | 説明 | （CSP設定の注意事項） | 常時表示 |
| Set up now | ボタン | Set up now | 常時表示 |
| Cancel | ボタン | Cancel | 常時表示 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|----------|
| 権限不足 | アクセス拒否（管理者モニター自体が非表示） |
| CSP既設定 | このモニターは表示されない（isActivated()がfalse） |
| 高優先度CSPDecider存在 | このモニターは表示されない（isActivated()がfalse） |

## 備考

- このモニターは`AdministrativeMonitor`を継承しており、Jenkins管理画面に自動的に表示されます
- `isSecurity()`メソッドがtrueを返すため、セキュリティ関連のモニターとして扱われます
- `CspConfiguration.enforce`がnullの場合（未設定）にのみ、このモニターがアクティブになります
- FallbackDeciderが現在のCSPヘッダー決定者である場合にのみ表示されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、CSP推奨設定画面の制御に使用されるクラス構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CspRecommendation.java | `core/src/main/java/jenkins/security/csp/impl/CspRecommendation.java` | 管理者モニターの実装クラス |
| 1-2 | CspConfiguration.java | `core/src/main/java/jenkins/security/csp/impl/CspConfiguration.java` | CSP設定の管理クラス |
| 1-3 | FallbackDecider.java | `core/src/main/java/jenkins/security/csp/impl/FallbackDecider.java` | デフォルトのCSPヘッダー決定者 |

**読解のコツ**: `CspRecommendation`は`AdministrativeMonitor`を継承しており、`isActivated()`メソッドでモニターの表示条件を制御します。CSP設定が未構成（enforce == null）かつFallbackDeciderが使用されている場合にのみ表示されます。

#### Step 2: エントリーポイントを理解する

リクエスト処理の起点を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CspRecommendation.java | `core/src/main/java/jenkins/security/csp/impl/CspRecommendation.java` | doAct()メソッドがアクションのエントリーポイント |

**主要処理フロー**:
1. **48-52行目**: getDisplayName()でモニター名を返却
2. **54-61行目**: isActivated()で表示条件を判定
3. **63-65行目**: isSecurity()でセキュリティモニターとしてマーク
4. **68-83行目**: doAct()で各アクション（setup/dismiss/defer/more）を処理

#### Step 3: ビューテンプレートを理解する

画面の実際のレンダリング処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.jelly | `core/src/main/resources/jenkins/security/csp/impl/CspRecommendation/index.jelly` | Jellyテンプレートによる画面レンダリング |

**主要処理フロー**:
- **26行目**: l:layoutでone-columnレイアウトを使用
- **28行目**: l:app-barでタイトル表示
- **29-37行目**: 説明段落（paragraph1-3）の表示
- **38-45行目**: フォームとボタン（Set up now、Cancel）

### プログラム呼び出し階層図

```
/manage (GET) - Jenkins管理画面
    │
    └─ 管理者モニター一覧表示
           │
           └─ CspRecommendation.isActivated()
                  │
                  ├─ CspConfiguration.enforce == null ?
                  │
                  └─ CspHeaderDecider.getCurrentDecider() == FallbackDecider ?

/manage/administrativeMonitor/.../act (POST)
    │
    └─ CspRecommendation.doAct()
           │
           ├─ [more] → /manage/administrativeMonitor/... へリダイレクト
           │
           ├─ [setup] → CspConfiguration.enforce = false
           │            → /manage/configureSecurity/#contentSecurityPolicy
           │
           ├─ [dismiss] → disable(true)
           │              → /manage/
           │
           └─ [defer] → /manage/
```

### データフロー図

```
[入力]               [処理]                    [出力]

GETリクエスト ───▶ CspRecommendation         ───▶ index.jelly HTML
                   │                              │
                   └─ isActivated()判定           └─ CSP設定案内画面

POSTリクエスト ───▶ doAct()                  ───▶ リダイレクト
(setup/defer/       │
 dismiss/more)      ├─ [setup] CspConfiguration.enforce = false
                    │          → /manage/configureSecurity/
                    │
                    ├─ [dismiss] disable(true)
                    │            → /manage/
                    │
                    └─ [defer/other] → /manage/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CspRecommendation.java | `core/src/main/java/jenkins/security/csp/impl/CspRecommendation.java` | ソース | CSP推奨モニターの実装 |
| CspConfiguration.java | `core/src/main/java/jenkins/security/csp/impl/CspConfiguration.java` | ソース | CSP設定の管理クラス |
| CspHeaderDecider.java | `core/src/main/java/jenkins/security/csp/CspHeaderDecider.java` | ソース | CSPヘッダー決定者インターフェース |
| FallbackDecider.java | `core/src/main/java/jenkins/security/csp/impl/FallbackDecider.java` | ソース | デフォルトのCSPヘッダー決定者 |
| index.jelly | `core/src/main/resources/jenkins/security/csp/impl/CspRecommendation/index.jelly` | テンプレート | CSP推奨画面のJellyテンプレート |
| Messages.properties | `core/src/main/resources/jenkins/security/csp/impl/Messages.properties` | リソース | メッセージリソース |
| AdministrativeMonitor.java | `core/src/main/java/hudson/model/AdministrativeMonitor.java` | ソース | 管理者モニター基底クラス |
