# 画面設計書 76-View設定

## 概要

本ドキュメントは、JenkinsのViewの設定を編集する画面の設計仕様を記述したものです。

### 本画面の処理概要

この画面はJenkinsのView（ジョブをグループ化して表示するためのビュー）の設定を編集するための画面です。View名、説明文、表示するジョブのフィルター条件、ウィジェットの表示設定などを構成することができます。Viewの種類（ListView、MyViewなど）によって設定項目が異なりますが、共通の設定項目として名前、説明、ビルドキュー/エグゼキューターのフィルタリング設定があります。

**業務上の目的・背景**：大規模なJenkins環境では数百から数千のジョブが存在することがあり、すべてのジョブを一覧で表示すると見通しが悪くなります。Viewを使用することで、プロジェクトチーム別、リリースブランチ別、ジョブタイプ別などの条件でジョブをグループ化し、効率的にジョブを管理できます。この設定画面では、Viewの基本設定と表示条件を定義することができます。

**画面へのアクセス方法**：
1. ダッシュボードのView一覧から該当Viewを選択
2. サイドメニューの「Edit View」または「Configure」リンクをクリック
3. URLは`/view/{ViewName}/configure`

**主要な操作・処理内容**：
1. View名の変更
2. View説明の編集（Markupフォーマッター対応）
3. 表示するジョブの条件設定（Viewタイプ固有）
4. ViewPropertyの設定（拡張プラグインによる追加設定）
5. ビルドキューのフィルタリング設定
6. エグゼキューターのフィルタリング設定
7. 設定の保存または適用

**画面遷移**：
- 遷移元：
  - ダッシュボード（View一覧）からのサイドメニュー
  - View詳細画面からのサイドメニュー
- 遷移先：
  - View一覧画面（設定保存後）
  - 同画面（Apply適用後）

**権限による表示制御**：
- View.CONFIGURE権限：設定の編集と保存が可能
- 権限なし：アクセス不可（403エラー）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | ビュー管理 | 主機能 | Viewの設定編集 |
| 4 | ジョブ（Job） | 補助機能 | 表示ジョブのフィルター設定 |
| 64 | フォームバリデーション | API連携 | 設定値の入力検証 |

## 画面種別

設定画面（フォーム編集）

## URL/ルーティング

- URL: `/view/{ViewName}/configure`
- 設定保存エンドポイント: `POST /view/{ViewName}/configSubmit`

## 入出力項目

| 項目名 | 入出力 | 必須 | 型 | 説明 |
|--------|--------|------|-----|------|
| name | 入出力 | はい | String | View名 |
| description | 入出力 | いいえ | String | View説明（Markupフォーマッター対応） |
| filterQueue | 入出力 | いいえ | Boolean | ビルドキューのフィルタリング（このViewのジョブのみ表示） |
| filterExecutors | 入出力 | いいえ | Boolean | エグゼキューターのフィルタリング（このViewのジョブのみ表示） |
| （Viewタイプ固有項目） | 入出力 | 可変 | 可変 | Viewタイプに応じた追加設定項目 |
| （ViewProperty項目） | 入出力 | 可変 | 可変 | ViewPropertyによる拡張設定項目 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| ページタイトル | テキスト | 「Edit View」 |
| アプリバータイトル | テキスト | 「Edit View」（または設定されたタイトル） |
| Name入力欄 | テキストボックス | View名入力フィールド（autocomplete="on"） |
| Description入力欄 | テキストエリア | View説明入力フィールド（Markupプレビュー対応） |
| Viewタイプ固有設定 | 可変 | configure-entries.jellyからインクルード |
| ViewProperty設定 | 可変 | f:descriptorListで動的に生成 |
| Widgetsセクション | セクション | ウィジェット関連設定 |
| Filter build queue | チェックボックス | ビルドキューのフィルタリング設定 |
| Filter build executors | チェックボックス | エグゼキューターのフィルタリング設定 |
| Save/Applyボタン | ボタン | 設定保存・適用ボタン |

## イベント仕様

### 1-設定保存（Save）

「Save」ボタン押下時に、フォームの内容をサーバーに送信し、設定を永続化します。

**処理フロー**:
1. フォームデータをPOST送信（/view/{ViewName}/configSubmit）
2. View.rename()でView名変更を処理
3. 各設定項目を更新
4. ViewProperty設定を更新
5. View.save()で永続化
6. View一覧画面へリダイレクト

### 2-設定適用（Apply）

「Apply」ボタン押下時に、フォームの内容をサーバーに送信し、設定を適用します（ページ遷移なし）。

**処理フロー**:
1. フォームデータをPOST送信
2. 各設定項目を更新
3. ViewProperty設定を更新
4. View.save()で永続化
5. 同じページに留まる

### 3-Descriptionプレビュー

Description入力欄でのプレビュー表示。

**処理フロー**:
1. テキスト入力時にプレビューエンドポイント（/markupFormatter/previewDescription）にリクエスト
2. MarkupFormatterで変換されたHTMLをプレビュー表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定保存（Save/Apply） | - | ファイル更新 | View設定がconfig.xmlに保存される |

### テーブル別更新項目詳細

Jenkinsは設定をXMLファイルで管理しているため、データベーステーブルは使用しません。

#### 設定ファイル

| 操作 | ファイル | 更新内容 | 備考 |
|-----|---------|---------|------|
| 設定保存 | config.xml | View設定全体 | `$JENKINS_HOME/`配下 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| Edit View | タイトル | Edit View | 常時表示 |
| Name | ラベル | Name | 常時表示 |
| Description | ラベル | Description | 常時表示 |
| description.description | ヘルプ | （説明テキスト） | 常時表示 |
| Widgets | セクション | Widgets | 常時表示 |
| widgets.description | ヘルプ | （ウィジェット説明） | 常時表示 |
| Filter build queue | ラベル | Filter build queue | 常時表示 |
| widgets.filterqueue.description | ヘルプ | （フィルター説明） | 常時表示 |
| Filter build executors | ラベル | Filter build executors | 常時表示 |
| widgets.filterexecutors.description | ヘルプ | （フィルター説明） | 常時表示 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|----------|
| View.CONFIGURE権限なし | アクセス拒否画面を表示 |
| View名重複 | FormExceptionでエラーメッセージを表示 |
| View名不正（空文字、禁止文字など） | FormExceptionでエラーメッセージを表示 |
| 設定保存エラー | エラーメッセージを表示 |

## 備考

- この画面はView抽象クラスで定義されており、ListView、MyViewなど各種Viewタイプで共通して使用されます
- Viewタイプ固有の設定は`configure-entries.jelly`からインクルードされます
- ViewPropertyによる拡張設定は`f:descriptorList`で動的に生成されます
- Description欄はMarkupFormatter（HTML、Markdown等）に対応しており、CodeMirrorエディタが利用可能です
- filterQueue/filterExecutorsにより、サイドパネルのビルドキューとエグゼキューター表示を当該Viewのジョブに限定できます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、View設定画面の制御に使用されるクラス構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | View.java | `core/src/main/java/hudson/model/View.java` | View抽象クラス。name、description、filterQueue、filterExecutorsフィールドを持つ |
| 1-2 | ViewProperty.java | `core/src/main/java/hudson/model/ViewProperty.java` | View拡張プロパティの基底クラス |

**読解のコツ**: `View`クラスは抽象クラスであり、具体的な実装は`ListView`、`AllView`、`MyView`などのサブクラスが提供します。共通設定項目は`View`クラスに定義されています。

#### Step 2: エントリーポイントを理解する

リクエスト処理の起点を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | View.java | `core/src/main/java/hudson/model/View.java` | doConfigSubmit()メソッドが設定保存のエントリーポイント |

**主要処理フロー**:
1. **159行目**: nameフィールドでView名を保持
2. **164-175行目**: descriptionフィールドで説明を保持
3. **169-170行目**: filterExecutors、filterQueueフラグ
4. **253-261行目**: rename()メソッドでView名変更を処理
5. **345-351行目**: save()メソッドで永続化

#### Step 3: ビューテンプレートを理解する

画面の実際のレンダリング処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | configure.jelly | `core/src/main/resources/hudson/model/View/configure.jelly` | Jellyテンプレートによる画面レンダリング |

**主要処理フロー**:
- **30行目**: l:layoutでView.CONFIGURE権限チェック
- **39-40行目**: instanceとdescriptorのセットアップ
- **42行目**: f:formでconfigSubmitへPOST
- **44-46行目**: View名入力フィールド
- **47-49行目**: Description入力フィールド（CodeMirror対応）
- **53行目**: configure-entries.jellyのインクルード（Viewタイプ固有設定）
- **56行目**: ViewPropertyの設定（f:descriptorList）
- **58-66行目**: Widgetsセクション（filterQueue、filterExecutors）
- **69行目**: Save/Applyボタン

### プログラム呼び出し階層図

```
/view/{ViewName}/configure (GET)
    │
    └─ View
           │
           └─ configure.jelly
                  │
                  ├─ instance (this View)
                  │
                  ├─ descriptor (ViewDescriptor)
                  │
                  ├─ configure-entries.jelly (Viewタイプ固有)
                  │
                  └─ f:descriptorList (ViewProperty)

/view/{ViewName}/configSubmit (POST)
    │
    └─ View.doConfigSubmit() [推定]
           │
           ├─ rename(newName)
           │      │
           │      └─ Jenkins.checkGoodName()
           │
           ├─ setDescription()
           │
           ├─ setFilterQueue()
           │
           ├─ setFilterExecutors()
           │
           ├─ ViewProperty設定更新
           │
           └─ save()
                  │
                  └─ owner.save() → config.xml更新
```

### データフロー図

```
[入力]               [処理]                    [出力]

GETリクエスト ───▶ View                      ───▶ configure.jelly HTML
                   │                              │
                   └─ 現在の設定値取得            └─ フォーム表示

POSTリクエスト ───▶ doConfigSubmit()         ───▶ リダイレクト
(フォームデータ)     │
                    ├─ rename()
                    │
                    ├─ 各フィールド更新
                    │
                    └─ save()
                           │
                           └─ config.xml更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| View.java | `core/src/main/java/hudson/model/View.java` | ソース | View抽象クラス |
| ViewDescriptor.java | `core/src/main/java/hudson/model/ViewDescriptor.java` | ソース | ViewのDescriptor基底クラス |
| ViewProperty.java | `core/src/main/java/hudson/model/ViewProperty.java` | ソース | View拡張プロパティ基底クラス |
| ListView.java | `core/src/main/java/hudson/model/ListView.java` | ソース | ListViewの実装 |
| configure.jelly | `core/src/main/resources/hudson/model/View/configure.jelly` | テンプレート | View設定画面のJellyテンプレート |
| configure-entries.jelly | 各Viewタイプのリソース配下 | テンプレート | Viewタイプ固有設定（オプション） |
| sidepanel.jelly | `core/src/main/resources/hudson/model/View/sidepanel.jelly` | テンプレート | サイドパネル |
