# 画面設計書 77-ビルド一覧（View）

## 概要

本ドキュメントは、View内のジョブのビルド履歴を一覧表示する画面の設計仕様を記述したものです。

### 本画面の処理概要

この画面は特定のViewに含まれるすべてのジョブのビルド履歴を統合して一覧表示する画面です。View単位でビルドの実行状況を時系列で確認することができ、複数のジョブにまたがるビルド活動を一元的に把握することができます。AllViewの場合はJenkins全体のビルド履歴が表示されます。

**業務上の目的・背景**：CI/CD環境では、複数のジョブが連携してパイプラインを構成することが一般的です。この画面を使用することで、View単位（プロジェクト単位、チーム単位など）でのビルド活動を一覧で確認でき、ビルドの頻度、成功率、最近の傾向などを把握することができます。特にAllViewでは、Jenkins全体のビルド活動を俯瞰することができます。

**画面へのアクセス方法**：
1. ダッシュボードのView一覧から該当Viewを選択
2. サイドメニューの「Build History」リンクをクリック
3. URLは`/view/{ViewName}/builds`

**主要な操作・処理内容**：
1. View内のジョブのビルド履歴を時系列で一覧表示
2. 各ビルドの結果（成功/失敗/中止等）を視覚的に表示
3. 各ビルドへのリンクによる詳細画面への遷移
4. ページネーション対応（大量のビルド履歴がある場合）

**画面遷移**：
- 遷移元：
  - ダッシュボード（View一覧）からのサイドメニュー
  - View詳細画面からのサイドメニュー
- 遷移先：
  - ビルド詳細画面（各ビルドをクリック）
  - ジョブ詳細画面（ジョブ名をクリック）

**権限による表示制御**：
- Item.READ権限：ビルド一覧の閲覧が可能（各ジョブに対する権限が必要）
- 権限のないジョブ：一覧から除外される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | ビュー管理 | 主機能 | View内ジョブのビルド一覧表示 |
| 6 | ビルド（Build） | 補助機能 | ビルド情報の取得・表示 |

## 画面種別

一覧画面（読み取り専用）

## URL/ルーティング

- URL: `/view/{ViewName}/builds`
- AllViewの場合: `/builds`

## 入出力項目

本画面は入力項目を持たない表示専用画面です。

| 項目名 | 入出力 | 説明 |
|--------|--------|------|
| なし | - | 入力項目なし |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| ページタイトル | テキスト | View名（it.displayName） |
| パンくずリスト | パンくず | 「Build History」 |
| アプリバータイトル | テキスト | 「Build History of {ViewName}」または「Build History of {JenkinsName}」 |
| ビルド一覧テーブル | テーブル | t:buildListTableタグによるビルド一覧 |

### ビルド一覧テーブルの列

| 列名 | 表示形式 | 説明 |
|------|----------|------|
| ステータス | アイコン | ビルド結果を示すアイコン（成功:青/緑、失敗:赤、中止:灰色等） |
| ビルド番号 | リンク | ビルド詳細画面へのリンク（例：#123） |
| ジョブ名 | リンク | ジョブ詳細画面へのリンク |
| 実行日時 | 日時 | ビルド開始日時 |
| 所要時間 | 時間 | ビルド実行時間 |

## イベント仕様

### 1-ビルド詳細表示

ビルド番号またはビルド行をクリックすると、該当ビルドの詳細画面へ遷移します。

**処理フロー**:
1. ビルド行/番号をクリック
2. `/job/{JobName}/{BuildNumber}/`へ遷移

### 2-ジョブ詳細表示

ジョブ名をクリックすると、該当ジョブの詳細画面へ遷移します。

**処理フロー**:
1. ジョブ名をクリック
2. `/job/{JobName}/`へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | 本画面は読み取り専用のため更新は発生しない |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| Build History | パンくず | Build History | 常時表示 |
| buildHistory | タイトル | Build History of {ViewName/JenkinsName} | 常時表示 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|----------|
| ビルド履歴なし | 空のテーブルを表示 |
| View権限なし | アクセス拒否 |
| ジョブ権限なし | 該当ジョブのビルドを一覧から除外 |

## 備考

- この画面はView抽象クラスで定義されており、すべてのViewタイプで共通して使用されます
- AllViewの場合は、ページタイトルがJenkinsインスタンス名（app.displayName）になります
- `it.builds`プロパティからビルドリストを取得し、`t:buildListTable`タグでレンダリングします
- ビルドリストはRunListクラスで管理され、権限フィルタリングが適用されます
- 大量のビルドがある場合は、ページネーション機能により分割表示されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ビルド一覧画面で使用されるデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | View.java | `core/src/main/java/hudson/model/View.java` | getBuilds()メソッドでRunListを取得 |
| 1-2 | RunList.java | `core/src/main/java/hudson/util/RunList.java` | ビルドリストの管理クラス |
| 1-3 | Run.java | `core/src/main/java/hudson/model/Run.java` | ビルド（実行）の基底クラス |

**読解のコツ**: `View.getBuilds()`メソッドはViewに含まれるすべてのジョブのビルドを集約した`RunList`を返します。`RunList`はイテレーション可能で、権限フィルタリングやページネーションをサポートします。

#### Step 2: エントリーポイントを理解する

リクエスト処理の起点を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | builds.jelly | `core/src/main/resources/hudson/model/View/builds.jelly` | ビルド一覧画面のエントリーポイント |

**主要処理フロー**:
1. **28行目**: l:layoutでページ全体のレイアウトを設定
2. **29行目**: sidepanel.jellyをインクルード
3. **30行目**: パンくずリスト「Build History」
4. **32-38行目**: アプリバーでタイトル表示（AllView判定付き）
5. **40行目**: t:buildListTableでビルド一覧をレンダリング

#### Step 3: ビルドリストテーブルを理解する

ビルド一覧の実際のレンダリング処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | buildListTable.jelly | `core/src/main/resources/lib/hudson/buildListTable.jelly` | ビルドリストテーブルのタグライブラリ |

**読解のコツ**: `t:buildListTable`はJenkinsのタグライブラリで定義されており、`builds`属性で渡されたRunListをテーブル形式でレンダリングします。

### プログラム呼び出し階層図

```
/view/{ViewName}/builds (GET)
    │
    └─ View
           │
           ├─ getBuilds()
           │      │
           │      └─ RunList (全ジョブのビルドを集約)
           │             │
           │             └─ 権限フィルタリング適用
           │
           └─ builds.jelly
                  │
                  ├─ sidepanel.jelly
                  │
                  ├─ jenkins-app-bar
                  │      │
                  │      └─ AllView判定 → タイトル文字列決定
                  │
                  └─ t:buildListTable
                         │
                         └─ it.builds
                                │
                                └─ 各Runの情報表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

GETリクエスト ───▶ View                      ───▶ builds.jelly HTML
                   │                              │
                   ├─ getBuilds()                 └─ ビルド一覧テーブル
                   │      │                            │
                   │      └─ RunList構築              ├─ ビルド結果アイコン
                   │             │                    ├─ ビルド番号リンク
                   │             ├─ 全ジョブを走査    ├─ ジョブ名リンク
                   │             │                    ├─ 実行日時
                   │             └─ 権限フィルタリング └─ 所要時間
                   │
                   └─ AllView判定
                          │
                          └─ タイトル文字列決定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| View.java | `core/src/main/java/hudson/model/View.java` | ソース | View抽象クラス、getBuilds()メソッド |
| RunList.java | `core/src/main/java/hudson/util/RunList.java` | ソース | ビルドリスト管理クラス |
| Run.java | `core/src/main/java/hudson/model/Run.java` | ソース | ビルド（実行）の基底クラス |
| AllView.java | `core/src/main/java/hudson/model/AllView.java` | ソース | AllViewの実装 |
| builds.jelly | `core/src/main/resources/hudson/model/View/builds.jelly` | テンプレート | ビルド一覧画面のJellyテンプレート |
| buildListTable.jelly | `core/src/main/resources/lib/hudson/buildListTable.jelly` | テンプレート | ビルドリストテーブルのタグライブラリ |
| sidepanel.jelly | `core/src/main/resources/hudson/model/View/sidepanel.jelly` | テンプレート | サイドパネル |
