# 画面設計書 8-ユーザー追加（管理者）

## 概要

本ドキュメントは、Jenkinsの管理者によるユーザー追加画面の設計仕様を定義するものです。

### 本画面の処理概要

ユーザー追加（管理者）画面は、Jenkins管理者が新しいユーザーアカウントを作成するための画面です。セルフサインアップとは異なり、管理者権限を持つユーザーのみがこの画面を使用できます。

**業務上の目的・背景**：セキュリティポリシー上、セルフサインアップを無効にしている環境でも、管理者がユーザーを追加する必要があります。この画面により、管理者が適切な権限管理の下で新規ユーザーを登録でき、組織のセキュリティポリシーに従ったユーザー管理が可能になります。

**画面へのアクセス方法**：ユーザー一覧画面（`/securityRealm/`）から「Create User」ボタンをクリックするか、URLで直接 `/securityRealm/addUser` にアクセスします。管理者権限（Jenkins.ADMINISTER）が必要です。

**主要な操作・処理内容**：
1. ユーザー名の入力 - 必須項目で、重複チェックあり
2. パスワードの入力と確認
3. フルネームの入力
4. メールアドレスの入力（Mailerプラグインがインストールされている場合）
5. Create Userボタン押下による登録処理

**画面遷移**：ユーザー一覧画面からこの画面に遷移します。登録成功後はユーザー一覧画面に戻ります。

**権限による表示制御**：Jenkins.ADMINISTER権限を持つユーザーのみがアクセスできます。権限がない場合は403エラーが返されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 30 | ユーザー管理 | 主機能 | 管理者による新規ユーザーの追加 |
| 29 | 認可（AuthorizationStrategy） | 補助機能 | 管理者権限の確認 |

## 画面種別

登録

## URL/ルーティング

- `/securityRealm/addUser` - ユーザー追加画面
- `/securityRealm/createAccountByAdmin` - アカウント作成処理エンドポイント

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| username | 入力 | String | ○ | ユーザー名 |
| password1 | 入力 | String | ○ | パスワード |
| password2 | 入力 | String | ○ | パスワード確認 |
| fullname | 入力 | String | - | フルネーム |
| email | 入力 | String | - | メールアドレス（Mailerプラグイン時） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| タイトル | Text | "Create User" |
| ユーザー名入力フィールド | TextInput | ユーザー名入力欄 |
| パスワード入力フィールド | PasswordInput | パスワード入力欄 |
| パスワード確認入力フィールド | PasswordInput | パスワード確認入力欄 |
| フルネーム入力フィールド | TextInput | フルネーム入力欄 |
| メールアドレス入力フィールド | TextInput | メールアドレス入力欄（条件付き） |
| Create Userボタン | Button | ユーザー作成ボタン |

## イベント仕様

### 1-Create Userボタン押下

フォームデータを `/securityRealm/createAccountByAdmin` にPOSTします。バリデーションが行われ、問題がなければアカウントが作成されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Create User押下 | $JENKINS_HOME/users/{userId}/ | INSERT | ユーザーディレクトリとconfig.xmlの作成 |

### テーブル別更新項目詳細

#### Jenkinsファイルシステム（$JENKINS_HOME/users/{userId}/config.xml）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| INSERT | fullName | フォーム入力値 | フルネーム |
| INSERT | properties/hudson.security.HudsonPrivateSecurityRealm_-Details | パスワードハッシュ | BCrypt等でハッシュ化 |
| INSERT | properties/hudson.tasks.Mailer_-UserProperty/emailAddress | フォーム入力値 | メールアドレス |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| Create User | ラベル | "Create User" | タイトル/ボタン |
| (バリデーションエラー) | エラー | 動的メッセージ | 入力検証エラー時 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| 管理者権限なし | 403 Forbiddenエラー |
| ユーザー名重複 | エラーメッセージ表示、登録不可 |
| パスワード不一致 | エラーメッセージ表示、登録不可 |
| 不正なユーザー名 | エラーメッセージ表示（正規表現チェック） |

## 備考

- この画面ではCAPTCHAは使用されません（`captcha="${false}"`）
- `_entryFormPage.jelly`タグファイルを使用して共通のフォームレイアウトを適用しています
- セルフサインアップ画面（signup.jelly）とは異なり、管理者専用の処理エンドポイント（`createAccountByAdmin`）を使用します

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ユーザー情報の保存構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | User.java | `core/src/main/java/hudson/model/User.java` | ユーザーモデルの基底クラス |
| 1-2 | HudsonPrivateSecurityRealm.java | `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` | Details内部クラス |

**読解のコツ**: addUser.jellyは_entryFormPage.jellyに処理を委譲するシンプルな構造です。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | addUser.jelly | `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/addUser.jelly` | 画面のメインテンプレート |

**主要処理フロー**:
1. **30行目**: `local:_entryFormPage`タグを呼び出し
2. パラメータ: `host="${it}"`, `title="${%Create User}"`, `action="createAccountByAdmin"`, `captcha="${false}"`

#### Step 3: 共通フォームテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | _entryFormPage.jelly | `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/_entryFormPage.jelly` | 共通フォームページ |
| 3-2 | _entryForm.jelly | `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/_entryForm.jelly` | フォーム内容 |

**主要処理フロー**:
- _entryFormPage.jelly: レイアウト（one-column）、フォームアクション設定
- _entryForm.jelly: 入力フィールド（username, password1, password2, fullname, email）

#### Step 4: 管理者によるアカウント作成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | HudsonPrivateSecurityRealm.java | `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` | doCreateAccountByAdminメソッド |

**主要処理フロー**:
- 管理者権限の確認
- フォームデータの検証
- Userインスタンスの作成と保存

### プログラム呼び出し階層図

```
addUser.jelly (エントリーポイント)
    │
    └─ local:_entryFormPage
           │
           ├─ l:layout (one-column)
           │
           ├─ l:breadcrumb
           │
           └─ form → /securityRealm/createAccountByAdmin
                  │
                  ├─ local:_entryForm
                  │      ├─ username入力
                  │      ├─ password1入力
                  │      ├─ password2入力
                  │      ├─ fullname入力
                  │      └─ email入力（条件付き）
                  │
                  └─ f:bottomButtonBar
                         └─ f:submit "Create User"
```

### データフロー図

```
[入力]               [処理]                    [出力]

username ────────▶ 管理者権限チェック ───▶ User.config.xml
password1                  │
password2    ────────▶ doCreateAccountByAdmin() ───▶ Details（パスワード）
fullname                   │
email                      ▼
              ユーザー一覧画面へリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| addUser.jelly | `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/addUser.jelly` | テンプレート | メイン画面テンプレート |
| _entryFormPage.jelly | `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/_entryFormPage.jelly` | テンプレート | 共通フォームページ |
| _entryForm.jelly | `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/_entryForm.jelly` | テンプレート | フォーム内容 |
| HudsonPrivateSecurityRealm.java | `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` | ソース | アカウント作成処理 |
| User.java | `core/src/main/java/hudson/model/User.java` | ソース | ユーザーモデル |
