# 画面設計書 9-初回ユーザー作成

## 概要

本ドキュメントは、Jenkinsの初回ユーザー作成画面の設計仕様を定義するものです。

### 本画面の処理概要

初回ユーザー作成画面は、Jenkins初期セットアップ時に最初の管理者ユーザーを作成するための画面です。Jenkinsを新規インストールした際や、セキュリティ設定で「Jenkins独自のユーザーデータベース」を選択した後、ユーザーが存在しない場合に表示されます。

**業務上の目的・背景**：Jenkinsの初期セットアップにおいて、最初の管理者ユーザーを作成することは必須のステップです。この画面により、管理者権限を持つユーザーを安全に作成し、以降のJenkins管理を行う基盤を整えます。

**画面へのアクセス方法**：Jenkinsの初期セットアップ時、またはHudsonPrivateSecurityRealmが有効でユーザーが一人も存在しない場合に、任意のページにアクセスすると自動的にこの画面にリダイレクトされます。

**主要な操作・処理内容**：
1. ユーザー名の入力 - 必須項目
2. パスワードの入力と確認
3. フルネームの入力
4. メールアドレスの入力（Mailerプラグインがインストールされている場合）
5. Create First Admin Userボタン押下による登録処理

**画面遷移**：セットアップウィザードからこの画面に遷移する場合と、ユーザーが存在しない状態でJenkinsにアクセスした場合にリダイレクトされます。登録成功後はログイン画面またはダッシュボードに遷移します。

**権限による表示制御**：この画面は特別な画面であり、ユーザーが一人も存在しない場合にのみ表示されます。既にユーザーが存在する場合はアクセスできません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 30 | ユーザー管理 | 主機能 | 初期管理者ユーザーの作成 |
| 28 | 認証（SecurityRealm） | 補助機能 | 初期セキュリティ設定 |

## 画面種別

登録（初期設定）

## URL/ルーティング

- `/securityRealm/firstUser` - 初回ユーザー作成画面
- `/securityRealm/createFirstAccount` - アカウント作成処理エンドポイント

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| username | 入力 | String | ○ | ユーザー名 |
| password1 | 入力 | String | ○ | パスワード |
| password2 | 入力 | String | ○ | パスワード確認 |
| fullname | 入力 | String | - | フルネーム |
| email | 入力 | String | - | メールアドレス（Mailerプラグイン時） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| タイトル | Text | "Create First Admin User" |
| ユーザー名入力フィールド | TextInput | ユーザー名入力欄 |
| パスワード入力フィールド | PasswordInput | パスワード入力欄 |
| パスワード確認入力フィールド | PasswordInput | パスワード確認入力欄 |
| フルネーム入力フィールド | TextInput | フルネーム入力欄 |
| メールアドレス入力フィールド | TextInput | メールアドレス入力欄（条件付き） |
| Create First Admin Userボタン | Button | ユーザー作成ボタン |

## イベント仕様

### 1-Create First Admin Userボタン押下

フォームデータを `/securityRealm/createFirstAccount` にPOSTします。バリデーションが行われ、問題がなければ最初の管理者アカウントが作成されます。作成されたユーザーには自動的に管理者権限が付与されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Create First Admin User押下 | $JENKINS_HOME/users/{userId}/ | INSERT | ユーザーディレクトリとconfig.xmlの作成 |

### テーブル別更新項目詳細

#### Jenkinsファイルシステム（$JENKINS_HOME/users/{userId}/config.xml）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| INSERT | fullName | フォーム入力値 | フルネーム |
| INSERT | properties/hudson.security.HudsonPrivateSecurityRealm_-Details | パスワードハッシュ | BCrypt等でハッシュ化 |
| INSERT | properties/hudson.tasks.Mailer_-UserProperty/emailAddress | フォーム入力値 | メールアドレス |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| Create First Admin User | ラベル | "Create First Admin User" | タイトル/ボタン |
| (バリデーションエラー) | エラー | 動的メッセージ | 入力検証エラー時 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| 既にユーザーが存在 | この画面へのアクセス不可（フィルターで制御） |
| パスワード不一致 | エラーメッセージ表示、登録不可 |
| 不正なユーザー名 | エラーメッセージ表示 |

## 備考

- この画面ではCAPTCHAは使用されません
- 最初に作成されるユーザーは自動的に管理者権限が付与されます（tryToMakeAdmin）
- CREATE_FIRST_USER_FILTERによりユーザーが存在しない場合にのみ表示されます
- セットアップウィザードからも呼び出される共通のユーザー作成フォームです

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

初回ユーザー作成の特殊性を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HudsonPrivateSecurityRealm.java | `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` | CREATE_FIRST_USER_FILTERの定義 |
| 1-2 | User.java | `core/src/main/java/hudson/model/User.java` | ユーザーモデル |

**読解のコツ**: HudsonPrivateSecurityRealmのコンストラクタで、ユーザーが存在しない場合にCREATE_FIRST_USER_FILTERがPluginServletFilterに追加されます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | firstUser.jelly | `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/firstUser.jelly` | 画面のメインテンプレート |

**主要処理フロー**:
1. **30行目**: `local:_entryFormPage`タグを呼び出し
2. パラメータ: `host="${it}"`, `title="${%Create First Admin User}"`, `action="createFirstAccount"`, `captcha="${false}"`

#### Step 3: アカウント作成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | HudsonPrivateSecurityRealm.java | `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` | doCreateFirstAccountメソッド、tryToMakeAdmin |

**主要処理フロー**:
- createAccountメソッドでユーザー作成
- tryToMakeAdminで管理者権限を付与
- CREATE_FIRST_USER_FILTERを除去

#### Step 4: フィルターの仕組みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | HudsonPrivateSecurityRealm.java | `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` | CREATE_FIRST_USER_FILTERの実装 |

**主要処理フロー**:
- PluginServletFilterに登録
- ユーザーが存在しない場合に/securityRealm/firstUserへリダイレクト
- ユーザー作成後にフィルターを除去

### プログラム呼び出し階層図

```
[Jenkinsアクセス]
    │
    └─ CREATE_FIRST_USER_FILTER
           │
           └─ [ユーザー0人?]
                  │
                  ├─ Yes → /securityRealm/firstUser へリダイレクト
                  │              │
                  │              └─ firstUser.jelly
                  │                     │
                  │                     └─ local:_entryFormPage
                  │                            │
                  │                            └─ createFirstAccount
                  │                                   │
                  │                                   ├─ User作成
                  │                                   ├─ tryToMakeAdmin
                  │                                   └─ フィルター除去
                  │
                  └─ No → 通常処理
```

### データフロー図

```
[入力]               [処理]                    [出力]

username ────────▶ doCreateFirstAccount() ───▶ User.config.xml
password1                  │
password2    ────────▶ createAccount() ───────▶ Details（パスワード）
fullname                   │
email                      ├─ tryToMakeAdmin() ───▶ 管理者権限付与
                           │
                           └─ フィルター除去 → ログイン画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| firstUser.jelly | `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/firstUser.jelly` | テンプレート | メイン画面テンプレート |
| _entryFormPage.jelly | `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/_entryFormPage.jelly` | テンプレート | 共通フォームページ |
| _entryForm.jelly | `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/_entryForm.jelly` | テンプレート | フォーム内容 |
| HudsonPrivateSecurityRealm.java | `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` | ソース | フィルター、アカウント作成処理 |
| User.java | `core/src/main/java/hudson/model/User.java` | ソース | ユーザーモデル |
