---
generated_at: 2026-01-22 19:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-ダッシュボード（View一覧）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **データベース更新仕様のQueue INSERT**：ビルド実行時のキュー処理の詳細確認が必要
  2. **表示項目の最終成功/失敗ビルド**：ListViewColumnの実装詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/hudson/model/View/index.jelly`
- E-02: `core/src/main/java/hudson/model/View.java`
- E-03: `core/src/main/resources/hudson/model/View/sidepanel.jelly`
- E-04: `core/src/main/resources/hudson/model/View/main.jelly`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メインダッシュボード画面はジョブ一覧表示を行う | E-01, E-04 | ○ |
| C-02 | URLは/または/view/{viewName}/ | E-02 (getUrl(), getViewUrl()メソッド) | ○ |
| C-03 | 新旧UIの切り替え機能がある | E-01 (26-31行目) | ○ |
| C-04 | newDashboardPageフラグで切り替える | E-01 (27行目) | ○ |
| C-05 | RSSフィードが提供される | E-03 (33-37行目) | ○ |
| C-06 | サイドパネルに新規ジョブ作成リンクがある | E-03 (51-52行目) | ○ |
| C-07 | ビルド履歴リンクがある | E-03 (55行目) | ○ |
| C-08 | View.READ権限でジョブ表示が制御される | E-02 | ○ |
| C-09 | システムメッセージが表示される | E-01 (42-44行目) | ○ |
| C-10 | View説明が編集可能 | E-01 (45行目) | ○ |
| C-11 | ジョブが0件の場合noJob.jellyが表示される | E-04 (28行目) | ○ |
| C-12 | View設定破損時は"broken"メッセージ | E-04 (9行目) | ○ |
| C-13 | getItems()でジョブ一覧を取得 | E-02 (194-196行目) | ○ |
| C-14 | screen-resolution.jsが組み込まれる | E-01 (54-55行目) | ○ |
| C-15 | 関連機能はビュー管理(35)、ダッシュボード(38)など | E-06 | ○ |
| C-16 | ログイン後にこの画面に遷移する | E-07 (113行目) | ○ |
| C-17 | 新規ジョブ作成画面へ遷移できる | E-03, E-07 | ○ |
| C-18 | View設定画面へ遷移できる | E-03 (57-59行目) | ○ |
| C-19 | Viewタブでフィルタリングができる | E-04 (44-51行目) | ○ |
| C-20 | ウィジェットが表示される | E-03 (77-80行目) | ○ |
| C-21 | Item.CREATE権限で新規ジョブ作成が制御される | E-03 (51行目) | ○ |
| C-22 | View.CONFIGURE権限でView編集が制御される | E-03 (58行目) | ○ |
| C-23 | View.DELETE権限でView削除が制御される | E-03 (60-62行目) | ○ |
| C-24 | ビルド実行時にQueueにINSERTされる | **根拠なし** | △ |
| C-25 | 表示項目に最終成功/失敗ビルドが含まれる | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- ビルド実行時のキュー処理詳細：Queue.javaの詳細確認が必要
  - 候補：`core/src/main/java/hudson/model/Queue.java` / ビルドボタン押下時のアクション処理
- ListViewColumnの実装詳細：表示カラムの具体的な実装確認
  - 候補：`core/src/main/java/hudson/views/` 配下のカラムクラス群

## 5) リスクフラグ（レビュー観点）
- 0: 全体的に低リスク - 主要な機能説明は全てソースコードで裏付け可能
- 1: 中リスク - データベース更新仕様（JenkinsはファイルベースのためDB概念が異なる）

## 6) レビュアーチェックリスト（最小）
- [ ] 新旧UI切り替えの挙動が実際の動作と一致しているか
- [ ] 権限制御（READ/CONFIGURE/DELETE）が正しく記載されているか
- [ ] 画面遷移の記載が画面遷移図と整合しているか
- [ ] ビルド実行処理のキュー追加フローが正確か
