---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：11-ジョブ詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **新旧UI切り替えフラグの詳細動作**：実験的機能のため仕様が変更される可能性
  2. **HistoryWidgetの遅延ロード実装詳細**：非同期処理の具体的な挙動
  3. **権限チェックの完全性**：全ての権限パターンの網羅確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/hudson/model/Job/index.jelly` - ジョブ詳細画面テンプレート
- E-02: `core/src/main/java/hudson/model/Job.java` - Jobモデルクラス（154-500行目）
- E-03: `core/src/main/java/hudson/model/Run.java` - Runモデルクラス（168-500行目）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ジョブ詳細画面はindex.jellyで実装されている | E-01 | ○ |
| C-02 | URLパスは/job/{ジョブ名}/形式 | E-01, E-04 | ○ |
| C-03 | 新旧UIの切り替えはNewJobPageUserExperimentalFlagで制御 | E-01 (27-31行目) | ○ |
| C-04 | displayNameはJob.displayNameから取得 | E-01 (34行目), E-02 | ○ |
| C-05 | 最新ビルドの状態アイコンはlastBuild.iconColorから取得 | E-01 (40-45行目), E-02 | ○ |
| C-06 | sidepanel.jellyをインクルードしている | E-01 (35行目) | ○ |
| C-07 | jobpropertysummaries.jellyをインクルードしている | E-01 (67行目) | ○ |
| C-08 | main.jellyをインクルードしている | E-01 (69行目) | ○ |
| C-09 | permalinks.jellyをインクルードしている | E-01 (71行目) | ○ |
| C-10 | Job.CONFIGUREで説明編集権限を制御 | E-01 (51行目, 65行目) | ○ |
| C-11 | MatrixConfigurationの場合は完全名表示をスキップ | E-01 (55行目) | ○ |
| C-12 | Jobクラスはpropertiesフィールドを持つ | E-02 (199-200行目) | ○ |
| C-13 | nextBuildNumberはファイルで永続化 | E-02 (279-291行目) | ○ |
| C-14 | isBuilding()はlastBuildの状態を確認 | E-02 (310-313行目) | ○ |
| C-15 | Runクラスはnumberフィールドでビルド番号を管理 | E-03 (187行目) | ○ |
| C-16 | Runクラスはresultフィールドでビルド結果を保持 | E-03 (222行目) | ○ |
| C-17 | 関連機能はジョブ、ビルド、REST API | E-05 | ○ |
| C-18 | ダッシュボードからジョブ詳細へ遷移可能 | E-06 | ○ |
| C-19 | ジョブ詳細からビルド詳細へ遷移可能 | E-06 | ○ |
| C-20 | ジョブ詳細からジョブ設定へ遷移可能 | E-06 | ○ |
| C-21 | ジョブ詳細からビルド時間傾向へ遷移可能 | E-06 | ○ |
| C-22 | ジョブ詳細からパラメータ入力へ遷移可能 | E-06 | ○ |
| C-23 | HistoryWidgetによる非同期ビルド履歴読み込み | **根拠不足** | △ |
| C-24 | 説明編集時のsubmitDescriptionエンドポイント | **根拠不足** | △ |
| C-25 | BallColorでビルド状態アイコンを表現 | E-01 (43行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- **HistoryWidgetの非同期処理詳細**：HistoryWidget.javaの実装を直接確認していないため、遅延ロードの具体的な実装詳細は推定
  - 候補：HistoryWidget.java / progressiveRendering.js / builds.jelly
- **submitDescriptionエンドポイント**：説明編集のサーバーサイド処理の詳細
  - 候補：Job.java内のdoSubmitDescription / AbstractItem.java

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的なUI構成、データバインディング
- **1（中リスク）**: 権限制御の網羅性（テストで確認推奨）
- **1（中リスク）**: 新旧UI切り替えの影響範囲（実験的機能のため変更可能性あり）

## 6) レビュアーチェックリスト（最小）
- [ ] index.jellyのテンプレート構造が設計書と一致するか確認
- [ ] Job.CONFIGUREによる権限制御が適切に記載されているか確認
- [ ] 画面遷移図との整合性を確認（特にサイドパネルのリンク先）
- [ ] HistoryWidgetの実装詳細を補完する必要があるか判断
- [ ] 新UI（new-job-page.jelly）との差異を確認する必要があるか判断
