---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：12-ジョブ設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **doConfigSubmitの詳細実装**：保存処理の完全なフロー確認
  2. **適用ボタンの非同期処理**：AJAXによる保存処理の詳細
  3. **プラグインによる設定項目追加**：動的フォーム生成の挙動

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/model/Job/configure.jelly` - ジョブ設定画面テンプレート
- E-02: `core/src/main/java/hudson/model/Job.java` - Jobモデルクラス
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 設定画面はconfigure.jellyで実装されている | E-01 | ○ |
| C-02 | URLパスは/job/{ジョブ名}/configure形式 | E-01, E-03 | ○ |
| C-03 | EXTENDED_READ権限で閲覧可能 | E-01 (30行目) | ○ |
| C-04 | CONFIGURE権限がないとreadOnlyMode | E-01 (31行目) | ○ |
| C-05 | section-to-sidebar-items.jsをロード | E-01 (34行目) | ○ |
| C-06 | スティッキーサイドパネルを使用 | E-01 (39行目) | ○ |
| C-07 | フォームアクションはconfigSubmit | E-01 (47行目) | ○ |
| C-08 | 説明フィールドはf:textareaで実装 | E-01 (59行目) | ○ |
| C-09 | マークアッププレビュー機能あり | E-01 (59行目, previewEndpoint) | ○ |
| C-10 | f:descriptorListでプロパティ表示 | E-01 (63行目) | ○ |
| C-11 | configure-entries.jellyをインクルード | E-01 (66行目) | ○ |
| C-12 | f:saveApplyBarで保存・適用ボタン表示 | E-01 (68行目) | ○ |
| C-13 | 関連機能にSCM連携を含む | E-04 | ○ |
| C-14 | 関連機能にSCMトリガーを含む | E-04 | ○ |
| C-15 | 関連機能にタイマートリガーを含む | E-04 | ○ |
| C-16 | 関連機能にビルドステップを含む | E-04 | ○ |
| C-17 | 関連機能にフォームバリデーションを含む | E-04 | ○ |
| C-18 | ジョブ詳細から設定画面へ遷移可能 | E-05 | ○ |
| C-19 | 新規ジョブ作成から設定画面へ遷移 | E-05 | ○ |
| C-20 | 設定保存後ジョブ詳細へ遷移 | E-05 | ○ |
| C-21 | Generalセクションヘッダーあり | E-01 (48行目) | ○ |
| C-22 | ビルド無効化チェックボックスあり | E-01 (49行目) | ○ |
| C-23 | descriptorとinstanceをJelly変数に設定 | E-01 (52-53行目) | ○ |
| C-24 | スケルトンローディング表示あり | E-01 (55行目) | ○ |
| C-25 | 編集モードと読み取り専用モードのタイトル切り替え | E-01 (37行目, 40行目) | ○ |
| C-26 | パンくずリストにタイトル表示 | E-01 (37行目) | ○ |
| C-27 | doConfigSubmitで設定保存処理 | **根拠不足** | △ |
| C-28 | 適用ボタンの非同期保存処理 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **doConfigSubmitメソッドの実装詳細**：Job.javaのdoConfigSubmitメソッドの完全な実装を確認していない
  - 候補：Job.java内のdoConfigSubmit / AbstractProject.java
- **適用ボタンの非同期処理**：f:saveApplyBarの適用ボタン押下時のAJAX処理詳細
  - 候補：FormApply.java / saveApplyBar.jelly / form.js

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的なUI構成、権限チェック
- **1（中リスク）**: フォーム送信処理のエラーハンドリング
- **1（中リスク）**: プラグインによる動的設定項目の互換性

## 6) レビュアーチェックリスト（最小）
- [ ] configure.jellyのテンプレート構造が設計書と一致するか確認
- [ ] EXTENDED_READ/CONFIGURE権限の動作を実機で確認
- [ ] doConfigSubmitの実装詳細を補完する必要があるか判断
- [ ] 派生クラス（FreestyleProject等）のconfigure-entries.jellyを確認
- [ ] プラグインによる設定項目追加の動作を確認
