---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：13-ビルド時間傾向

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **JFreeChartによるグラフ生成実装**：グラフ生成の詳細確認
  2. **ProgressiveRenderingの詳細動作**：非同期処理の具体的な実装

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/model/Job/buildTimeTrend.jelly` - ビルド時間傾向画面テンプレート
- E-02: `core/src/main/java/hudson/model/Job.java` - Jobモデルクラス
- E-03: `core/src/main/java/hudson/model/Run.java` - Runモデルクラス
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はbuildTimeTrend.jellyで実装されている | E-01 | ○ |
| C-02 | URLパスは/job/{ジョブ名}/buildTimeTrend形式 | E-01, E-04 | ○ |
| C-03 | sidepanel.jellyをインクルード | E-01 (30行目) | ○ |
| C-04 | パンくずリストにBuild Time Trendを表示 | E-01 (31行目) | ○ |
| C-05 | buildTimeTrend_resourcesアジャンクトをインクルード | E-01 (32行目) | ○ |
| C-06 | ステータスアイコンのテンプレートを定義 | E-01 (34-49行目) | ○ |
| C-07 | BuildTimeTrendハンドラーを使用 | E-01 (53行目) | ○ |
| C-08 | handler.setBuilds()でビルドリストを設定 | E-01 (54行目) | ○ |
| C-09 | showAgentはノード存在とAbstractProjectで判定 | E-01 (55行目) | ○ |
| C-10 | ProgressiveRenderingを使用 | E-01 (56行目) | ○ |
| C-11 | コールバックはbuildTimeTrend_displayBuilds | E-01 (56行目) | ○ |
| C-12 | テーブルはsortableクラスを持つ | E-01 (58行目) | ○ |
| C-13 | テーブルIDはtrend | E-01 (58行目) | ○ |
| C-14 | ビルド列は初期降順ソート | E-01 (63行目, initialSortDir="up") | ○ |
| C-15 | showAgentの場合のみエージェント列を表示 | E-01 (66-68行目) | ○ |
| C-16 | 最後の列はソート無効化 | E-01 (69行目, data-sort-disable="true") | ○ |
| C-17 | グラフ画像はbuildTimeGraph/pngから取得 | E-01 (76行目) | ○ |
| C-18 | イメージマップはbuildTimeGraph/mapから取得 | E-01 (76行目, lazymap) | ○ |
| C-19 | グラフサイズは500x400 | E-01 (76行目) | ○ |
| C-20 | 関連機能にジョブとビルドを含む | E-05 | ○ |
| C-21 | アイコンサイズはt:setIconSizeで設定 | E-01 (57行目) | ○ |
| C-22 | JFreeChartでグラフ生成 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **グラフ生成実装の詳細**：Job.javaのbuildTimeGraphエンドポイントの完全な実装を確認していない
  - 候補：Job.java内のgetBuildTimeGraph / Graph.java

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的なUI構成、テーブル表示
- **1（中リスク）**: ProgressiveRenderingの大量データ時のパフォーマンス
- **0（低リスク）**: イメージマップのリンク生成

## 6) レビュアーチェックリスト（最小）
- [ ] buildTimeTrend.jellyのテンプレート構造が設計書と一致するか確認
- [ ] BuildTimeTrend.javaのハンドラー実装を確認
- [ ] グラフ生成（buildTimeGraph/png）の実装詳細を確認
- [ ] テーブルソート機能の動作を実機で確認
- [ ] showAgentフラグの判定条件を確認
