---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：14-ビルド詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **新旧UI切り替えの詳細動作**：実験的機能のため仕様変更の可能性
  2. **アクションサマリーの動的インクルード**：各アクションのsummary.jelly実装
  3. **ビルド保持のtoggleLogKeepエンドポイント**：サーバーサイド処理の詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/model/Run/index.jelly` - ビルド詳細画面テンプレート
- E-02: `core/src/main/java/hudson/model/Run.java` - Runモデルクラス
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はindex.jellyで実装されている | E-01 | ○ |
| C-02 | URLパスは/job/{ジョブ名}/{ビルド番号}/形式 | E-01, E-03 | ○ |
| C-03 | NewBuildPageUserExperimentalFlagで新旧UI切り替え | E-01 (28行目) | ○ |
| C-04 | 新UIはnew-build-page.jellyをインクルード | E-01 (32行目) | ○ |
| C-05 | レイアウトタイトルはfullDisplayName | E-01 (35行目) | ○ |
| C-06 | sidepanel.jellyをインクルード | E-01 (36行目) | ○ |
| C-07 | Run.UPDATEで説明編集ボタン表示制御 | E-01 (41行目) | ○ |
| C-08 | Run.UPDATEでlogKeep表示制御 | E-01 (42-44行目) | ○ |
| C-09 | t:buildCaptionでキャプション表示 | E-01 (47行目) | ○ |
| C-10 | formatDateでタイムスタンプをフォーマット | E-01 (47行目) | ○ |
| C-11 | t:editableDescriptionで説明表示 | E-01 (50行目) | ○ |
| C-12 | timestampStringで経過時間表示 | E-01 (55行目) | ○ |
| C-13 | buildingフラグで実行中判定 | E-01 (58行目, 61行目) | ○ |
| C-14 | executor.timestampStringで実行時間表示 | E-01 (59行目) | ○ |
| C-15 | durationStringで所要時間表示 | E-01 (62行目) | ○ |
| C-16 | buildTimeTrendへのリンクあり | E-01 (62行目) | ○ |
| C-17 | details.jellyをオプショナルインクルード | E-01 (64行目) | ○ |
| C-18 | t:artifactListで成果物表示 | E-01 (70行目) | ○ |
| C-19 | allActionsをループしてsummary.jelly表示 | E-01 (73-75行目) | ○ |
| C-20 | summary.jellyをオプショナルインクルード | E-01 (77行目) | ○ |
| C-21 | main.jellyをオプショナルインクルード | E-01 (80行目) | ○ |
| C-22 | Runクラスにnumber, result, durationフィールドあり | E-02 | ○ |
| C-23 | 関連機能にビルド、成果物、変更ログを含む | E-04 | ○ |
| C-24 | ジョブ詳細からビルド詳細へ遷移可能 | E-05 | ○ |
| C-25 | toggleLogKeepエンドポイントでビルド保持 | **根拠不足** | △ |
| C-26 | submitDescriptionエンドポイントで説明保存 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **toggleLogKeepエンドポイントの実装**：Run.javaのdoToggleLogKeepメソッドの詳細を確認していない
  - 候補：Run.java内のdoToggleLogKeep / keepLog関連メソッド
- **submitDescriptionエンドポイントの実装**：Run.javaのdoSubmitDescriptionメソッドの詳細を確認していない
  - 候補：Run.java / AbstractModelObject.java

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的なUI構成、データバインディング
- **1（中リスク）**: 新旧UI切り替えの影響範囲（実験的機能）
- **1（中リスク）**: アクションサマリーの動的表示（プラグイン依存）

## 6) レビュアーチェックリスト（最小）
- [ ] index.jellyのテンプレート構造が設計書と一致するか確認
- [ ] Run.UPDATEによる権限制御が適切に記載されているか確認
- [ ] logKeep.jellyの実装を確認
- [ ] 各アクションのsummary.jellyインクルードの動作を確認
- [ ] 新UI（new-build-page.jelly）との差異を確認する必要があるか判断
