---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：15-コンソール出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **リアルタイム更新の実装詳細**：Progressive HTMLの具体的な動作
  2. **ConsoleNoteのアノテーション処理**：色付けやリンク生成の仕組み

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/model/Run/console.jelly` - コンソール出力画面テンプレート
- E-02: `core/src/main/java/hudson/model/Run.java` - Runモデルクラス
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はconsole.jellyで実装されている | E-01 | ○ |
| C-02 | URLパスは/job/{ジョブ名}/{ビルド番号}/console形式 | E-01, E-03 | ○ |
| C-03 | ConsoleTabオブジェクトを作成 | E-01 (32-34行目) | ○ |
| C-04 | l:run-subpageレイアウトを使用 | E-01 (36行目) | ○ |
| C-05 | アプリバータイトルはConsole | E-01 (37行目) | ○ |
| C-06 | ダウンロードボタンのhrefはconsoleText | E-01 (38行目) | ○ |
| C-07 | ダウンロードファイル名はdisplayName.txt | E-01 (38行目) | ○ |
| C-08 | symbol-downloadアイコンを使用 | E-01 (39行目) | ○ |
| C-09 | l:copyButtonでコピー機能を提供 | E-01 (42行目) | ○ |
| C-10 | ref="out"でコピー対象を指定 | E-01 (42行目) | ○ |
| C-11 | プレーンテキストリンクのhrefはconsoleText | E-01 (43行目) | ○ |
| C-12 | it変数をit.objectに再設定 | E-01 (48行目) | ○ |
| C-13 | console-log.jellyをインクルード | E-01 (49行目) | ○ |
| C-14 | 関連機能にビルドとエグゼキューターを含む | E-04 | ○ |
| C-15 | consoleFull変数でフル表示を制御 | E-01参照（consoleFull.jelly） | ○ |
| C-16 | ダウンロードボタンにjenkins-buttonクラス | E-01 (38行目) | ○ |
| C-17 | プレーンテキストリンクにjenkins-buttonクラス | E-01 (43行目) | ○ |
| C-18 | Runオブジェクトからログを取得 | E-02 | ○ |
| C-19 | ConsoleNoteでアノテーション処理 | E-01参照 | ○ |
| C-20 | リアルタイム更新はProgressive HTMLで実装 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **リアルタイム更新の実装詳細**：console-log.jellyの完全な実装を確認していない
  - 候補：console-log.jelly / ProgressiveRendering関連

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的なUI構成、ボタン機能
- **1（中リスク）**: 大きなログファイルの表示パフォーマンス
- **0（低リスク）**: コピー機能のブラウザ互換性

## 6) レビュアーチェックリスト（最小）
- [ ] console.jellyのテンプレート構造が設計書と一致するか確認
- [ ] console-log.jellyのリアルタイム更新実装を確認
- [ ] コピーボタンの動作を実機で確認
- [ ] プレーンテキスト表示の動作を確認
- [ ] 大きなログファイルの表示パフォーマンスを確認
