---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-コンソール出力（フル）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 特になし。この画面は非常にシンプルなラッパーです。

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/model/Run/consoleFull.jelly` - フル表示画面テンプレート
- E-02: `core/src/main/resources/hudson/model/Run/console.jelly` - コンソール出力画面テンプレート
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はconsoleFull.jellyで実装されている | E-01 | ○ |
| C-02 | URLパスは/job/{ジョブ名}/{ビルド番号}/consoleFull形式 | E-01, E-03 | ○ |
| C-03 | consoleFull変数をtrueに設定 | E-01 (26行目) | ○ |
| C-04 | console.jellyをインクルード | E-01 (27行目) | ○ |
| C-05 | 関連機能にビルドを含む | E-04 | ○ |
| C-06 | ラッパーとしてconsole.jellyを再利用 | E-01 | ○ |
| C-07 | コンソール出力画面と同じUI構成 | E-01, E-02 | ○ |
| C-08 | ダウンロード、コピー、プレーンテキスト機能あり | E-02 | ○ |
| C-09 | ページネーションなしで全ログ表示 | E-01（consoleFull=trueの効果） | ○ |
| C-10 | j:jellyでXML名前空間を定義 | E-01 (25行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。この画面の実装は非常にシンプルで、すべての主張に根拠があります。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: シンプルなラッパー実装
- **1（中リスク）**: 大きなログファイルのメモリ使用量（運用上の注意事項として記載済み）

## 6) レビュアーチェックリスト（最小）
- [ ] consoleFull.jellyがconsoleFull=trueを設定してconsole.jellyをインクルードしているか確認
- [ ] 大きなログファイルでのパフォーマンスを確認
