---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：18-ビルド削除確認

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **doDoDeleteの実装詳細**：削除処理の完全なフローを確認

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/model/Run/confirmDelete.jelly` - 削除確認画面テンプレート
- E-02: `core/src/main/java/hudson/model/Run.java` - Runモデルクラス
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はconfirmDelete.jellyで実装されている | E-01 | ○ |
| C-02 | URLパスは/job/{ジョブ名}/{ビルド番号}/confirmDelete形式 | E-01, E-03 | ○ |
| C-03 | レイアウトタイトルはfullDisplayName | E-01 (29行目) | ○ |
| C-04 | sidepanel.jellyをインクルード | E-01 (30行目) | ○ |
| C-05 | パンくずリストに「Confirm deletion」 | E-01 (31行目) | ○ |
| C-06 | whyKeepLogを変数に設定 | E-01 (33行目) | ○ |
| C-07 | 保持理由がある場合、警告を表示 | E-01 (34-36行目) | ○ |
| C-08 | 警告にwarningクラスを使用 | E-01 (35行目) | ○ |
| C-09 | 保持理由がない場合、削除フォームを表示 | E-01 (38-42行目) | ○ |
| C-10 | フォームアクションはdoDelete | E-01 (39行目) | ○ |
| C-11 | フォームメソッドはpost | E-01 (39行目) | ○ |
| C-12 | delete.buildメッセージで確認テキスト表示 | E-01 (40行目) | ○ |
| C-13 | 削除ボタンにjenkins-!-destructive-colorクラス | E-01 (41行目) | ○ |
| C-14 | 関連機能にビルドとログローテーションを含む | E-04 | ○ |
| C-15 | RunクラスにkeepLog、whyKeepLogあり | E-02 | ○ |
| C-16 | 削除ボタンのラベルは「Delete」 | E-01 (41行目) | ○ |
| C-17 | 確認メッセージにdisplayNameを含む | E-01 (40行目) | ○ |
| C-18 | doDoDeleteで削除処理 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **doDoDeleteメソッドの実装詳細**：Run.javaのdoDoDeleteメソッドの完全な実装を確認していない
  - 候補：Run.java内のdoDoDelete / delete

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的なUI構成
- **2（高リスク）**: 削除は不可逆操作（設計書に警告として記載済み）

## 6) レビュアーチェックリスト（最小）
- [ ] confirmDelete.jellyのテンプレート構造が設計書と一致するか確認
- [ ] whyKeepLogの動作を確認
- [ ] doDoDeleteの実装詳細を補完する必要があるか判断
- [ ] 削除後のリダイレクト先を確認
