---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：19-成果物一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ArtifactManagerの実装詳細**：成果物取得の完全なフローを確認

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/model/Run/artifacts-index.jelly` - 成果物一覧画面テンプレート
- E-02: `core/src/main/java/hudson/model/Run.java` - Runモデルクラス
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はartifacts-index.jellyで実装されている | E-01 | ○ |
| C-02 | ARTIFACTS権限が有効な場合のみ権限チェック | E-01 (27行目) | ○ |
| C-03 | レイアウトタイトルは「fullDisplayName Artifacts」 | E-01 (28行目) | ○ |
| C-04 | sidepanel.jellyをインクルード | E-01 (29行目) | ○ |
| C-05 | パンくずリストに「Artifacts」 | E-01 (30行目) | ○ |
| C-06 | t:buildCaptionで「Build Artifacts」表示 | E-01 (32行目) | ○ |
| C-07 | テーブルにfileListクラス | E-01 (33行目) | ○ |
| C-08 | it.artifactsでループ | E-01 (34行目) | ○ |
| C-09 | icon-documentアイコンを使用 | E-01 (37行目) | ○ |
| C-10 | リンクhrefはartifact/{f.href} | E-01 (40行目) | ○ |
| C-11 | displayPathでファイル名表示 | E-01 (40行目) | ○ |
| C-12 | fileSizeクラスでサイズ表示 | E-01 (42行目) | ○ |
| C-13 | f.lengthでサイズ取得 | E-01 (43行目) | ○ |
| C-14 | 関連機能に成果物アーカイブとビルドを含む | E-04 | ○ |
| C-15 | RunクラスにgetArtifactsメソッドあり | E-02 | ○ |
| C-16 | isArtifactsPermissionEnabledで権限設定確認 | E-01 (27行目) | ○ |
| C-17 | hasPermission(ARTIFACTS)で権限チェック | E-01 (27行目) | ○ |
| C-18 | ArtifactManagerで成果物管理 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **ArtifactManagerの実装詳細**：ArtifactManager.javaとStandardArtifactManager.javaの完全な実装を確認していない
  - 候補：ArtifactManager.java / StandardArtifactManager.java

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的なUI構成
- **1（中リスク）**: ARTIFACTS権限の有効/無効による動作差異

## 6) レビュアーチェックリスト（最小）
- [ ] artifacts-index.jellyのテンプレート構造が設計書と一致するか確認
- [ ] ARTIFACTS権限の有効/無効時の動作を確認
- [ ] ArtifactManagerの実装詳細を補完する必要があるか判断
- [ ] 大量の成果物がある場合の表示を確認
