---
generated_at: 2026-01-22 19:32:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：2-新規ジョブ作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **nextBuildNumber初期値**：ジョブ作成時のnextBuildNumber設定の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/model/View/newJob.jelly`
- E-02: `core/src/main/java/hudson/model/View.java`
- E-03: `core/src/main/java/hudson/model/Item.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新規ジョブ作成画面でジョブを作成できる | E-01, E-04 | ○ |
| C-02 | URLは/newJobまたは/view/{viewName}/newJob | E-01 | ○ |
| C-03 | Item.CREATE権限が必要 | E-01 (27行目) | ○ |
| C-04 | ジョブ名入力が必須 | E-01 (44-46行目) | ○ |
| C-05 | ジョブタイプをラジオボタンで選択 | E-01 (53行目) | ○ |
| C-06 | 既存ジョブからコピー可能 | E-01 (56-66行目) | ○ |
| C-07 | 既存ジョブがある場合のみコピーオプション表示 | E-01 (56行目) | ○ |
| C-08 | createItemアクションにPOST | E-01 (40行目) | ○ |
| C-09 | add-item.cssでスタイル定義 | E-01 (31行目) | ○ |
| C-10 | add-item.jsでJavaScript定義 | E-01 (32行目) | ○ |
| C-11 | 関連機能はジョブ(4)、フォームバリデーション(64) | E-05 | ○ |
| C-12 | ダッシュボードから遷移 | E-06 | ○ |
| C-13 | 作成後はジョブ設定画面へ遷移 | E-06 (125行目) | ○ |
| C-14 | ジョブ名の重複チェックが行われる | E-01 (46行目), E-02 | ○ |
| C-15 | バリデーションメッセージが表示される | E-01 (45-47行目) | ○ |
| C-16 | layout type="one-column"で表示 | E-01 (29行目) | ○ |
| C-17 | copyNewItemFromフィールドでコピー元を指定 | E-01 (63行目) | ○ |
| C-18 | bottomButtonBarでボタン配置 | E-01 (68-70行目) | ○ |
| C-19 | ジョブタイプはプラグインで拡張可能 | E-03 | ○ |
| C-20 | nextBuildNumber初期値は1 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- nextBuildNumberの初期化処理詳細
  - 候補：`core/src/main/java/hudson/model/Run.java` / AbstractProject初期化処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構成とバリデーションはソースコードで明確に確認可能
- 0: 低リスク - 権限チェックロジックも明確

## 6) レビュアーチェックリスト（最小）
- [ ] ジョブ名バリデーションの禁止文字リストが正確か
- [ ] コピー機能の挙動が正しく記載されているか
- [ ] 権限エラー時の動作が403であることを確認
