---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：20-パラメータ入力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **contents.jellyの詳細実装**：パラメータフォームの完全なレンダリング

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/model/ParametersDefinitionProperty/index.jelly` - パラメータ入力画面テンプレート
- E-02: `core/src/main/java/hudson/model/ParametersDefinitionProperty.java` - パラメータプロパティクラス
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はindex.jellyで実装されている | E-01 | ○ |
| C-02 | URLパスは/job/{ジョブ名}/build形式 | E-01, E-03 | ○ |
| C-03 | HTTPステータス405を返す | E-01 (37行目) | ○ |
| C-04 | レイアウトタイトルはジョブ表示名 | E-01 (38行目) | ○ |
| C-05 | ジョブのsidepanel.jellyをインクルード | E-01 (39行目) | ○ |
| C-06 | job.pronounとdisplayNameを表示 | E-01 (41行目) | ○ |
| C-07 | descriptionメッセージを表示 | E-01 (42行目) | ○ |
| C-08 | contents.jellyをインクルード | E-01 (43行目) | ○ |
| C-09 | ParametersDefinitionPropertyはJobPropertyを継承 | E-02 (76行目) | ○ |
| C-10 | parameterDefinitionsリストを保持 | E-02 (81行目) | ○ |
| C-11 | getBuildButtonTextメソッドあり | E-02 (97-99行目) | ○ |
| C-12 | _doBuildメソッドでビルド実行 | E-02 (155-193行目) | ○ |
| C-13 | delayパラメータを処理 | E-02 (156-157行目) | ○ |
| C-14 | JSONからパラメータを抽出 | E-02 (162-180行目) | ○ |
| C-15 | ParameterDefinition.createValueでパラメータ値生成 | E-02 (174行目) | ○ |
| C-16 | Queue.scheduleでビルドキューに追加 | E-02 (183行目) | ○ |
| C-17 | ParametersActionを作成 | E-02 (184行目) | ○ |
| C-18 | CauseActionでUserIdCauseを設定 | E-02 (184行目) | ○ |
| C-19 | 関連機能にパラメータ定義、文字列、選択、ブールを含む | E-04 | ○ |
| C-20 | 関連機能にキュー管理を含む | E-04 | ○ |
| C-21 | リダイレクト処理を行う | E-02 (186-192行目) | ○ |
| C-22 | contents.jellyでパラメータフォームをレンダリング | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **contents.jellyの実装詳細**：パラメータフォームの完全なレンダリング処理を確認していない
  - 候補：contents.jelly / 各ParameterDefinitionのconfig.jelly

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的なUI構成
- **1（中リスク）**: パラメータタイプによるフォームレンダリングの違い
- **0（低リスク）**: キューへの追加処理

## 6) レビュアーチェックリスト（最小）
- [ ] index.jellyのテンプレート構造が設計書と一致するか確認
- [ ] contents.jellyの実装詳細を補完する必要があるか判断
- [ ] 各パラメータタイプ（String、Choice、Boolean等）のconfig.jellyを確認
- [ ] _doBuildの詳細フローを確認
- [ ] HTTPステータス405の意図を確認
