---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：21-ノード一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **メッセージ仕様**：定義されたメッセージの確認が必要
  2. **nodeMonitors.xmlの更新仕様**：ファイル構造の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/hudson/model/ComputerSet/index.jelly`
- E-02: `core/src/main/java/hudson/model/ComputerSet.java`
- E-03: `core/src/main/java/hudson/model/Computer.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名が「ノード一覧」である | E-04 (行22) | ○ |
| C-02 | テンプレートファイルパスがindex.jellyである | E-04, E-01 | ○ |
| C-03 | URLが/computer/である | E-02 (getSearchUrl()行237-239) | ○ |
| C-04 | 関連機能にコンピューター管理(12)がある | E-05 (行54-56) | ○ |
| C-05 | 関連機能にノードモニター(13)がある | E-05 (行55) | ○ |
| C-06 | 関連機能にエージェントノード(10)がある | E-05 (行56) | ○ |
| C-07 | New Nodeボタンが存在する | E-01 (行37-40) | ○ |
| C-08 | Computer.CREATE権限でNew Nodeボタンの表示制御 | E-01 (行35-36) | ○ |
| C-09 | Configure Monitorsボタンが存在する | E-01 (行44-46) | ○ |
| C-10 | MANAGE_AND_SYSTEM_READ権限で設定ボタンの表示制御 | E-01 (行42-43) | ○ |
| C-11 | Refresh statusボタンが存在する | E-01 (行49-52) | ○ |
| C-12 | hasAdministerOrManageタグで更新ボタンの権限制御 | E-01 (行48) | ○ |
| C-13 | ノード一覧がテーブル形式で表示される | E-01 (行67) | ○ |
| C-14 | テーブルがソート可能(sortable)である | E-01 (行67) | ○ |
| C-15 | 状態アイコンが表示される | E-01 (行85-88) | ○ |
| C-16 | ノード名がリンクとして表示される | E-01 (行91-93) | ○ |
| C-17 | 監視データ列が動的に生成される | E-01 (行95-100) | ○ |
| C-18 | 設定リンクアイコンが表示される | E-01 (行102-110) | ○ |
| C-19 | EXTENDED_READ権限で設定リンクの表示制御 | E-01 (行103) | ○ |
| C-20 | doUpdateNowメソッドが状態更新処理を行う | E-02 (行262-273) | ○ |
| C-21 | Jenkins.MANAGE権限がdoUpdateNowに必要 | E-02 (行263) | ○ |
| C-22 | getComputers()がノード一覧を取得する | E-02 (行132-135) | ○ |
| C-23 | ノードが名前でソートされる | E-02 (行134) | ○ |
| C-24 | Legendボタンが存在する | E-01 (行135-138) | ○ |
| C-25 | クラウドからのノード情報も表示される | E-01 (行115-117) | ○ |
| C-26 | アイコンサイズが選択可能である | E-01 (行133-139) | ○ |
| C-27 | メッセージ仕様に定義されたメッセージがない | **要確認** | △ |
| C-28 | nodeMonitors.xmlがモニター設定を保存する | E-02 (行466-468) | ○ |

## 4) 不足情報（Unknown / Missing）
- Messages.propertiesファイルの詳細な確認が未実施
  - 候補：`core/src/main/resources/hudson/model/ComputerSet/Messages.properties`
- 実際のnodeMonitors.xmlファイル構造の確認が未実施
  - 候補：`$JENKINS_HOME/nodeMonitors.xml`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面の基本構造と権限制御は明確にコードで確認可能
- 0: 低リスク - URLルーティングは標準的なStapler規約に従っている
- 1: 中リスク - メッセージ仕様の網羅性は追加確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のindex.jellyテンプレートと画面設計書の記載が一致しているか確認
- [ ] 権限制御の記載が実際のコード実装と整合しているか確認
- [ ] 監視データ列の動的生成について、NodeMonitorの実装を確認
- [ ] Messages.propertiesで定義されているメッセージの網羅確認
