---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：22-ノード詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **setOfflineCauseの遷移先**：正確な遷移先画面の確認が必要
  2. **ComputerLauncherの手動起動UI**：各Launcher実装の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/model/Computer/index.jelly`
- E-02: `core/src/main/java/hudson/model/Computer.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名が「ノード詳細」である | E-03 (行23) | ○ |
| C-02 | テンプレートファイルパスがindex.jellyである | E-03, E-01 | ○ |
| C-03 | URLが/computer/{nodeName}/である | E-02 (getUrl()行779-781) | ○ |
| C-04 | 関連機能にコンピューター管理(12)がある | E-04 (行57-60) | ○ |
| C-05 | 関連機能にノードモニター(13)がある | E-04 (行58) | ○ |
| C-06 | 関連機能にラベル管理(68)がある | E-04 (行59) | ○ |
| C-07 | オフライン切り替えボタンが存在する | E-01 (行37-55) | ○ |
| C-08 | Computer.CONNECT権限でオンライン復帰の制御 | E-01 (行39) | ○ |
| C-09 | Computer.DISCONNECT権限でオフライン設定の制御 | E-01 (行49) | ○ |
| C-10 | オフライン理由の表示機能がある | E-01 (行61-63) | ○ |
| C-11 | モニタリングデータが折りたたみ表示される | E-01 (行73-83) | ○ |
| C-12 | ラベル一覧がクラウド形式で表示される | E-01 (行85-96) | ○ |
| C-13 | セルフラベルが除外される | E-01 (行90) | ○ |
| C-14 | 紐づきジョブ一覧が表示される | E-01 (行100-111) | ○ |
| C-15 | getTiedJobs()でジョブ一覧を取得する | E-02 (行792-795) | ○ |
| C-16 | doToggleOffline()がオフライン切り替えを行う | E-02 (行1401-1414) | ○ |
| C-17 | setTemporaryOfflineCause()が理由を設定する | E-02 (行725-731) | ○ |
| C-18 | getMonitoringData()で監視データを取得する | E-02 (行1141-1150) | ○ |
| C-19 | 説明編集にCONFIGURE権限が必要 | E-01 (行32) | ○ |
| C-20 | 手動起動コントロールが条件付きで表示される | E-01 (行33-35, 65-67) | ○ |
| C-21 | isManualLaunchAllowed()が起動許可を判定する | E-02 (行644-648) | ○ |
| C-22 | 紐づきジョブがない場合「None」を表示 | E-01 (行104-106) | ○ |
| C-23 | オフライン時のみオフライン理由を表示 | E-01 (行61) | ○ |
| C-24 | setOfflineCauseへの遷移がある | E-01 (行43-45) | ○ |
| C-25 | setOfflineCause画面の遷移先詳細 | **要確認** | △ |
| C-26 | ComputerLauncherの実装詳細 | **プラグイン依存** | △ |

## 4) 不足情報（Unknown / Missing）
- setOfflineCause.jellyの詳細実装確認が未実施
  - 候補：`core/src/main/resources/hudson/model/Computer/setOfflineCause.jelly`
- 各ComputerLauncherのapp-bar-controls.jellyの確認が未実施
  - 候補：各Launcher実装のリソースディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面の基本構造と権限制御は明確にコードで確認可能
- 0: 低リスク - オフライン切り替え処理は標準的なフォームPOST
- 1: 中リスク - ComputerLauncherの実装はプラグインにより異なる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のindex.jellyテンプレートと画面設計書の記載が一致しているか確認
- [ ] 権限制御の記載が実際のコード実装と整合しているか確認
- [ ] オフライン関連の状態遷移が正しく記載されているか確認
- [ ] 各Launcherタイプでの手動起動UI差異を確認
