---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：24-ノード負荷統計

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **グラフの凡例色**：LoadStatistics/main.jellyでの実際の色定義確認

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/model/Computer/load-statistics.jelly`
- E-02: `core/src/main/java/hudson/model/Computer.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名が「ノード負荷統計」である | E-03 (行25) | ○ |
| C-02 | テンプレートファイルパスがload-statistics.jellyである | E-03, E-01 | ○ |
| C-03 | URLが/computer/{nodeName}/load-statistics/である | E-01 (ファイルパス) | ○ |
| C-04 | 関連機能にロード統計(48)がある | E-04 (行64-65) | ○ |
| C-05 | 関連機能にコンピューター管理(12)がある | E-04 (行65) | ○ |
| C-06 | ページタイトルが設定される | E-01 (行27) | ○ |
| C-07 | パンくずリストに追加される | E-01 (行29) | ○ |
| C-08 | LoadStatisticsのmain.jellyがインクルードされる | E-01 (行31) | ○ |
| C-09 | sidepanel.jellyがインクルードされる | E-01 (行28) | ○ |
| C-10 | getLoadStatistics()で統計取得 | E-02 (行607-610) | ○ |
| C-11 | LabelAtomからloadStatisticsを取得 | E-02 (行609) | ○ |
| C-12 | 入力項目がない（表示のみ） | E-01 (全体構造) | ○ |
| C-13 | データ更新がない（表示のみ） | E-01 (全体構造) | ○ |
| C-14 | 短期/中期/長期の時間スケールがある | **main.jelly要確認** | △ |
| C-15 | グラフはLoadStatistics.main.jellyで描画 | E-01 (行31) | ○ |
| C-16 | 特別な権限制御がない | E-01 (権限チェックなし) | ○ |

## 4) 不足情報（Unknown / Missing）
- LoadStatistics/main.jellyの詳細確認が未実施
  - 候補：`core/src/main/resources/hudson/model/LoadStatistics/main.jelly`
- グラフの色定義と凡例の確認が未実施

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面の基本構造は明確にコードで確認可能
- 0: 低リスク - データ取得処理は単純なgetter呼び出し
- 1: 中リスク - グラフ描画の詳細はmain.jellyの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のload-statistics.jellyテンプレートと設計書の一致確認
- [ ] LoadStatistics/main.jellyでのグラフ描画仕様確認
- [ ] 時間スケールの種類と表示方法の確認
