---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：25-ノードオフライン設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **setOfflineCause.jellyの詳細**：フォーム要素の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/model/Computer/markOffline.jelly`
- E-02: `core/src/main/java/hudson/model/Computer.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `core/src/main/java/hudson/slaves/OfflineCause.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名が「ノードオフライン設定」である | E-03 (行26) | ○ |
| C-02 | テンプレートファイルパスがmarkOffline.jellyである | E-03, E-01 | ○ |
| C-03 | URLが/computer/{nodeName}/markOfflineである | E-01 (ファイルパス) | ○ |
| C-04 | DISCONNECT権限が必要 | E-02 (行1418) | ○ |
| C-05 | doChangeOfflineCause()で処理 | E-02 (行1416-1421) | ○ |
| C-06 | OfflineCause.UserCauseが生成される | E-02 (行1419) | ○ |
| C-07 | User.current()が使用される | E-02 (行1419) | ○ |
| C-08 | setTemporaryOfflineCause()に委譲 | E-02 (行1419) | ○ |
| C-09 | markOffline.jellyがsidepanel.jellyをインクルード | E-01 (行31) | ○ |
| C-10 | markOffline.jellyがsetOfflineCause.jellyをインクルード | E-01 (行33) | ○ |
| C-11 | offlineMessage入力フィールドがある | **setOfflineCause.jelly要確認** | △ |
| C-12 | HttpResponses.redirectToDot()でリダイレクト | E-02 (行1420) | ○ |
| C-13 | OfflineCause.UserCauseがユーザーとメッセージを保持 | E-04 (UserCauseクラス) | ○ |
| C-14 | オフライン理由は空でも設定可能 | E-02 (Util.fixEmptyAndTrim使用) | ○ |
| C-15 | オフライン状態はNode設定に保存される | E-02 (行725-731) | ○ |
| C-16 | getTemporaryOfflineCauseReason()で既存理由取得 | E-02 (行738-749) | ○ |
| C-17 | 関連機能にコンピューター管理(12)がある | E-03, マッピング | ○ |
| C-18 | ビルトインノードもオフライン設定可能 | E-01 (特別な除外なし) | ○ |

## 4) 不足情報（Unknown / Missing）
- setOfflineCause.jellyの詳細確認が未実施
  - 候補：`core/src/main/resources/hudson/model/Computer/setOfflineCause.jelly`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 権限制御と処理フローは明確にコードで確認可能
- 0: 低リスク - フォームPOSTとリダイレクトは標準的な実装
- 0: 低リスク - OfflineCauseの構造は明確

## 6) レビュアーチェックリスト（最小）
- [ ] markOffline.jellyの構造と設計書の一致確認
- [ ] setOfflineCause.jellyのフォーム要素確認
- [ ] doChangeOfflineCause()の権限チェックと処理フロー確認
