---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：26-クラウド一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **ドラッグ＆ドロップUI**：JavaScriptの実装詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/jenkins/agents/CloudSet/index.jelly`
- E-02: `core/src/main/java/jenkins/agents/CloudSet.java`
- E-03: `core/src/main/java/hudson/slaves/Cloud.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名が「クラウド一覧」である | E-04 (行27) | ○ |
| C-02 | テンプレートファイルパスがindex.jellyである | E-04, E-01 | ○ |
| C-03 | URLが/cloud/である | E-02 (getUrlName()行97-99) | ○ |
| C-04 | 関連機能にクラウド(11)がある | E-04 (マッピング) | ○ |
| C-05 | SYSTEM_READ権限でアクセス可能 | E-02 (getTarget()行80-84) | ○ |
| C-06 | getClouds()でクラウド一覧取得 | E-02 (行162-164) | ○ |
| C-07 | hasClouds()でクラウド有無判定 | E-02 (行167-169) | ○ |
| C-08 | isCloudAvailable()でプラグイン有無判定 | E-02 (行140-142) | ○ |
| C-09 | doCreate()で新規作成第一段階 | E-02 (行207-246) | ○ |
| C-10 | doDoCreate()で新規作成実行 | E-02 (行261-275) | ○ |
| C-11 | doReorder()で順序変更 | E-02 (行277-289) | ○ |
| C-12 | ADMINISTER権限でdoReorder実行 | E-02 (行279) | ○ |
| C-13 | Cloud.doDoDelete()で削除 | E-03 (行312-317) | ○ |
| C-14 | ADMINISTER権限でdoDoDelete実行 | E-03 (行314) | ○ |
| C-15 | CloudSet_CloudAlreadyExistsメッセージ | E-02 (行184, 335) | ○ |
| C-16 | CloudSet_NoSuchCloudメッセージ | E-02 (行222) | ○ |
| C-17 | clouds.replaceBy()で順序更新 | E-02 (行287) | ○ |
| C-18 | clouds.remove()で削除 | E-03 (行315) | ○ |
| C-19 | checkName()で名前検証 | E-02 (行176-188) | ○ |
| C-20 | Jenkins.checkGoodName()が使用される | E-02 (行181) | ○ |
| C-21 | 新規作成時に_new.jellyが使用される | E-02 (行255) | ○ |
| C-22 | ドラッグ＆ドロップでの順序変更 | **JS実装要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- index.jellyのJavaScript部分（ドラッグ＆ドロップ）の詳細確認が未実施
  - 候補：`core/src/main/js/`配下のスクリプト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - クラウド一覧取得と権限制御は明確にコードで確認可能
- 0: 低リスク - CRUD操作の実装は標準的なStapler規約
- 1: 中リスク - UI操作（ドラッグ＆ドロップ）のJS実装は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のindex.jellyテンプレートと設計書の一致確認
- [ ] 権限制御の記載が実際のコード実装と整合しているか確認
- [ ] 順序変更UIのJS実装確認
- [ ] エラーメッセージの網羅確認
