---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：27-クラウド詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **プラグイン固有ビューの詳細**：各クラウドプラグインのビュー確認

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/slaves/Cloud/index.jelly`
- E-02: `core/src/main/java/hudson/slaves/Cloud.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名が「クラウド詳細」である | E-03 (行28) | ○ |
| C-02 | テンプレートファイルパスがindex.jellyである | E-03, E-01 | ○ |
| C-03 | URLが/cloud/{cloudName}/である | E-02 (getUrl()行142-144) | ○ |
| C-04 | Cloud.nameフィールドがある | E-02 (行118) | ○ |
| C-05 | getDisplayName()が名前を返す | E-02 (行131-134) | ○ |
| C-06 | getUrl()がURLパスを返す | E-02 (行142-144) | ○ |
| C-07 | doDoDelete()で削除 | E-02 (行312-317) | ○ |
| C-08 | ADMINISTER権限でdoDoDelete実行 | E-02 (行314) | ○ |
| C-09 | clouds.remove()で削除 | E-02 (行315) | ○ |
| C-10 | HttpRedirect("..")でリダイレクト | E-02 (行316) | ○ |
| C-11 | doConfigSubmit()で設定更新 | E-02 (行322-341) | ○ |
| C-12 | getIcon()がアイコンを返す | E-02 (行296-298) | ○ |
| C-13 | getIconClassName()が定義されている | E-02 (行300-302) | ○ |
| C-14 | index.jellyでsidepanel.jellyをインクルード | E-01 (行30) | ○ |
| C-15 | top.jelly/main.jellyがオプションでインクルード | E-01 (行32-45) | ○ |
| C-16 | プラグイン固有ビューの詳細 | **各プラグイン要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- 各クラウドプラグイン（EC2、Kubernetes等）のtop.jelly、main.jellyの確認が未実施
  - 候補：各プラグインのリソースディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Cloud基底クラスの実装は明確にコードで確認可能
- 0: 低リスク - 削除処理と権限チェックは標準的な実装
- 1: 中リスク - プラグイン固有のビューはプラグインにより異なる

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のindex.jellyテンプレートと設計書の一致確認
- [ ] Cloud.javaの主要メソッドの確認
- [ ] 各クラウドプラグインのビュー実装状況確認
