---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：28-Jenkins管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **index.jellyの詳細構造**：カテゴリ分類の実装詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/model/ManageJenkinsAction/index.jelly`
- E-02: `core/src/main/java/hudson/model/ManageJenkinsAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名が「Jenkins管理」である | E-03 (行29) | ○ |
| C-02 | テンプレートファイルパスがindex.jellyである | E-03, E-01 | ○ |
| C-03 | URLが/manage/である | E-02 (getUrlName()行73-75) | ○ |
| C-04 | ManageJenkinsActionがRootActionを実装 | E-02 (行55) | ○ |
| C-05 | getDisplayName()が定義されている | E-02 (行67-70) | ○ |
| C-06 | getIconFileName()が定義されている | E-02 (行59-65) | ○ |
| C-07 | MANAGE権限またはSYSTEM_READ権限で表示 | E-02 (行61) | ○ |
| C-08 | doIndex()でリダイレクト判定 | E-02 (行82-95) | ○ |
| C-09 | NewManageJenkinsUserExperimentalFlagを使用 | E-02 (行84) | ○ |
| C-10 | 有効時にconfigureへリダイレクト | E-02 (行87) | ○ |
| C-11 | StaplerFallbackを実装 | E-02 (行55, 98-100) | ○ |
| C-12 | getStaplerFallback()がJenkinsを返す | E-02 (行98-100) | ○ |
| C-13 | doContextMenu()が定義されている | E-02 (行103-105) | ○ |
| C-14 | getBadge()で通知バッジを取得 | E-02 (行124-143) | ○ |
| C-15 | isSecurity()でセキュリティ通知を判定 | E-02 (行134) | ○ |
| C-16 | Badge.Severity.DANGERでセキュリティ表示 | E-02 (行135-136) | ○ |
| C-17 | Badge.Severity.WARNINGでその他表示 | E-02 (行137-139) | ○ |
| C-18 | isActive()でモニター有効性判定 | E-02 (行145-152) | ○ |
| C-19 | addContextMenuItem()が定義されている | E-02 (行112-120) | ○ |
| C-20 | index.jellyのカテゴリ別グループ化 | **index.jelly要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- index.jellyの詳細構造（カテゴリ分類、管理リンク表示）の確認が未実施
  - 候補：`core/src/main/resources/hudson/model/ManageJenkinsAction/index.jelly`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なAction実装は明確にコードで確認可能
- 0: 低リスク - リダイレクト処理と権限チェックは標準的な実装
- 1: 中リスク - UIのカテゴリ分類はindex.jellyの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ManageJenkinsAction.javaの主要メソッド確認
- [ ] index.jellyのレイアウト構造確認
- [ ] ManagementLink拡張ポイントの確認
- [ ] AdministrativeMonitorの表示条件確認
