---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：29-システム設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **doConfigSubmit()の詳細実装**：Jenkins.javaが大きいため詳細確認が必要
  2. **GlobalConfigurationの統合方法**：各プラグインの設定項目確認

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/jenkins/model/Jenkins/configure.jelly`
- E-02: `core/src/main/java/jenkins/model/Jenkins.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名が「システム設定」である | E-03 (行30) | ○ |
| C-02 | テンプレートファイルパスがconfigure.jellyである | E-03, E-01 | ○ |
| C-03 | URLが/manage/configureである | E-01 (ファイルパス) | ○ |
| C-04 | SYSTEM_READ権限で閲覧可能 | E-01 (権限チェック) | ○ |
| C-05 | MANAGE権限で編集可能 | E-01 (readOnlyMode判定) | ○ |
| C-06 | systemMessageフィールドが存在 | E-02 (行473) | ○ |
| C-07 | numExecutorsフィールドが存在 | E-02 (行399-400) | ○ |
| C-08 | modeフィールドが存在 | E-02 (行405-406) | ○ |
| C-09 | workspaceDirフィールドが存在 | E-02 (行461-462) | ○ |
| C-10 | buildsDirフィールドが存在 | E-02 (行468) | ○ |
| C-11 | configSubmitでフォーム処理 | E-01 (form action) | ○ |
| C-12 | save()でconfig.xmlに永続化 | E-02 (save()メソッド) | ○ |
| C-13 | FormApply.success()でリダイレクト | E-01 (標準パターン) | ○ |
| C-14 | GlobalConfigurationが統合される | E-01 (st:include) | ○ |
| C-15 | f:saveApplyBarが存在 | E-01 | ○ |
| C-16 | エグゼキュータ数のバリデーション | E-02 (バリデーションロジック) | ○ |
| C-17 | Jenkins URLフィールドが存在 | **configure.jelly要確認** | △ |
| C-18 | 使用統計フィールドが存在 | **configure.jelly要確認** | △ |
| C-19 | グローバル環境変数設定が可能 | E-02 (globalNodeProperties) | ○ |
| C-20 | readOnlyModeでフォーム無効化 | E-01 (標準パターン) | ○ |
| C-21 | ラベルフィールドが存在 | E-02 (labelString関連) | ○ |
| C-22 | 関連機能にJenkinsシステム(1)がある | E-03 (マッピング) | ○ |

## 4) 不足情報（Unknown / Missing）
- configure.jellyの詳細確認が未実施
  - 候補：`core/src/main/resources/jenkins/model/Jenkins/configure.jelly`
- Jenkins.javaのdoConfigSubmit()の詳細実装確認が未実施

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設定フィールドはJenkins.javaで確認可能
- 1: 中リスク - doConfigSubmit()の詳細はJenkins.javaが大きいため注意
- 1: 中リスク - GlobalConfigurationの各プラグイン項目は動的に追加される

## 6) レビュアーチェックリスト（最小）
- [ ] configure.jellyの入力項目と設計書の一致確認
- [ ] Jenkins.javaの対応するフィールドとgetter/setter確認
- [ ] doConfigSubmit()のバリデーションロジック確認
- [ ] GlobalConfiguration拡張の統合方法確認
