---
generated_at: 2026-01-22 19:34:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：3-新規View作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **コピー機能の詳細**：既存Viewコピー時の挙動詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/jenkins/model/Jenkins/newView.jelly`
- E-02: `core/src/main/java/hudson/model/View.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新規View作成画面でViewを作成できる | E-01, E-03 | ○ |
| C-02 | URLは/newView | E-01 | ○ |
| C-03 | View.CREATE権限が必要 | E-01 (30行目) | ○ |
| C-04 | View名入力が必須 | E-01 (35行目 nameTitle属性) | ○ |
| C-05 | Viewタイプを選択可能 | E-01 (34-36行目) | ○ |
| C-06 | View.allInstantiable()でタイプ取得 | E-01 (34行目) | ○ |
| C-07 | 既存Viewからコピー可能 | E-01 (35行目 copyTitle属性) | ○ |
| C-08 | createViewアクションにPOST | E-01 (35行目 action属性) | ○ |
| C-09 | checkViewNameでバリデーション | E-01 (36行目 checkUrl属性) | ○ |
| C-10 | 関連機能はビュー管理(35)、リストビュー(36) | E-04 | ○ |
| C-11 | ダッシュボードから遷移 | E-05 (120-121行目) | ○ |
| C-12 | サイドパネルが含まれる | E-01 (31行目) | ○ |
| C-13 | newFromListタグライブラリを使用 | E-01 (35行目 xmlns:n) | ○ |
| C-14 | Viewタイプはプラグインで拡張可能 | E-02 | ○ |
| C-15 | config.xmlにViewが保存される | E-02 | ○ |
| C-16 | リストビューがデフォルトで利用可能 | E-02 | ○ |
| C-17 | タイトルは"New View" | E-01 (30, 32, 35行目) | ○ |
| C-18 | コピー時のView設定の引継ぎ詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Viewコピー時の設定引継ぎ詳細
  - 候補：`core/src/main/java/jenkins/model/Jenkins.java` / doCreateViewメソッドのコピー処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構成は明確にソースコードで確認可能
- 0: 低リスク - 権限チェックロジックも明確

## 6) レビュアーチェックリスト（最小）
- [ ] View名バリデーションのエラーメッセージが正確か
- [ ] 利用可能なViewタイプ一覧が正確か
- [ ] コピー機能の動作が正しく記載されているか
