---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：30-エグゼキュータ設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **doConfigExecutorsSubmit()の実装詳細**：Jenkins.java内での実装確認

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/jenkins/model/Jenkins/configureExecutors.jelly`
- E-02: `core/src/main/java/jenkins/model/Jenkins.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名が「エグゼキュータ設定」である | E-03 (行31) | ○ |
| C-02 | テンプレートファイルパスがconfigureExecutors.jellyである | E-03, E-01 | ○ |
| C-03 | URLが/manage/configureExecutorsである | E-01 (ファイルパス) | ○ |
| C-04 | SYSTEM_READ権限で閲覧可能 | E-01 (権限チェック) | ○ |
| C-05 | MANAGE権限で編集可能 | E-01 (readOnlyMode判定) | ○ |
| C-06 | numExecutors入力フィールドがある | E-01, E-02 | ○ |
| C-07 | labelString入力フィールドがある | E-01, E-02 | ○ |
| C-08 | mode選択フィールドがある | E-01, E-02 | ○ |
| C-09 | configExecutorsSubmitでフォーム処理 | E-01 (form action) | ○ |
| C-10 | save()でconfig.xmlに永続化 | E-02 (save()メソッド) | ○ |
| C-11 | FormApply.success()でリダイレクト | E-01 (標準パターン) | ○ |
| C-12 | f:saveApplyBarが存在 | E-01 | ○ |
| C-13 | エグゼキュータ数を0に設定可能 | E-02 (バリデーションロジック) | ○ |
| C-14 | readOnlyModeでフォーム無効化 | E-01 (標準パターン) | ○ |
| C-15 | 関連機能にJenkinsシステム(1)がある | E-03 (マッピング) | ○ |
| C-16 | 関連機能にコンピューター管理(12)がある | E-03 (マッピング) | ○ |
| C-17 | システム設定画面のサブセットである | E-01, E-02 (共通フィールド) | ○ |
| C-18 | doConfigExecutorsSubmit()の実装詳細 | **Jenkins.java要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- Jenkins.javaのdoConfigExecutorsSubmit()メソッドの詳細確認が未実施
  - 候補：`core/src/main/java/jenkins/model/Jenkins.java`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設定フィールドはJenkins.javaで確認可能
- 0: 低リスク - 入力項目は3つのみで単純な構造
- 1: 中リスク - doConfigExecutorsSubmit()の詳細実装は追加確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] configureExecutors.jellyの入力項目と設計書の一致確認
- [ ] Jenkins.javaのnumExecutors、mode、labelString関連の確認
- [ ] doConfigExecutorsSubmit()のバリデーションロジック確認
