---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：31-システム情報

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **メッセージ仕様の詳細**：プロパティファイルの完全な確認が必要
  2. **機密情報マスク処理の詳細**：sensitiveフラグの実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/jenkins/model/Jenkins/systemInfo.jelly`（行30-105）
- E-02: `core/src/main/java/jenkins/management/SystemInfoLink.java`（行38-72）
- E-03: `core/src/main/java/hudson/PluginManager.java`（行205-300）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行32）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行78-79）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`（行59-70）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLが`/manage/systemInfo`である | E-02（行63-64: `getUrlName()`が"systemInfo"を返す） | ○ |
| C-02 | MANAGE_AND_SYSTEM_READ権限でアクセス制御される | E-01（行32: `permissions="${app.MANAGE_AND_SYSTEM_READ}"`) | ○ |
| C-03 | システムプロパティタブが存在する | E-01（行37-40: `l:tabPane title="${%System Properties}"`) | ○ |
| C-04 | 環境変数タブが存在する | E-01（行42-46: `l:tabPane title="${%Environment Variables}"`) | ○ |
| C-05 | プラグインタブが存在する | E-01（行48-83: `l:tabPane title="${%Plugins}"`) | ○ |
| C-06 | メモリ使用状況タブが存在する | E-01（行85-97: `l:tabPane title="${%Memory Usage}"`) | ○ |
| C-07 | スレッドダンプタブは管理者のみ表示 | E-01（行99-103: `l:isAdmin`で囲まれている） | ○ |
| C-08 | SYSTEM_READ権限でシステムプロパティ・環境変数が閲覧可能 | E-01（行36, 42: `l:hasPermission permission="${app.SYSTEM_READ}"`) | ○ |
| C-09 | プラグイン一覧は名前・バージョン・有効状態を表示 | E-01（行55-80: テーブル列定義） | ○ |
| C-10 | Timespan選択肢がShort/Medium/Longである | E-01（行88-93: select要素内のoption） | ○ |
| C-11 | プラグインリンクは外部URLで新しいタブで開く | E-01（行67-70: `target="_blank" rel="noopener noreferrer"`) | ○ |
| C-12 | プラグインがない場合「No plugins installed」メッセージ表示 | E-01（行50-52: `l:notice`要素） | ○ |
| C-13 | 画面カテゴリがSTATUSである | E-02（行70-71: `return Category.STATUS`) | ○ |
| C-14 | SystemInfoLinkがManagementLinkを継承している | E-02（行38: `extends ManagementLink`) | ○ |
| C-15 | アイコンがsymbol-serverである | E-02（行41-43: `return "symbol-server"`) | ○ |
| C-16 | section-to-tabs.jsが読み込まれる | E-01（行33: `src="${resURL}/jsbundles/section-to-tabs.js"`) | ○ |
| C-17 | system-information.jsが読み込まれる | E-01（行34: `src="${resURL}/jsbundles/pages/manage-jenkins/system-information.js"`) | ○ |
| C-18 | sensitiveフラグでプロパティがマスクされる | E-01（行38, 44: `sensitive="true"`) | ○ |
| C-19 | プラグイン一覧はソート可能なテーブルで表示 | E-01（行54: `class="jenkins-table sortable"`) | ○ |
| C-20 | 失敗したプラグインも表示される | E-01（行50: `app.pluginManager.failedPlugins`の参照） | ○ |
| C-21 | Jenkins管理画面から遷移可能 | E-06（行157-169: MANAGEからSYS_INFOへの遷移） | ○ |
| C-22 | 関連機能がJenkins本体と環境変数である | E-05（行78-79） | ○ |
| C-23 | 画面Noが31である | E-04（行32） | ○ |
| C-24 | 機密情報マスク処理の詳細実装 | **根拠なし** | △ |
| C-25 | メッセージプロパティファイルの完全な内容 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 機密情報マスク処理の詳細実装
  - 候補：`Functions.java`の`getSystemProperties()`実装 / `propertyTable.jelly`のsensitive処理 / セキュリティ設定ドキュメント
- メッセージプロパティファイルの完全な内容
  - 候補：`systemInfo.properties` / `systemInfo_ja.properties`

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：権限チェックの実装（コードで明確に確認済み）
- 0（低リスク）：タブ構成（Jellyテンプレートで明確に定義）
- 1（中リスク）：機密情報マスク処理（実装詳細の追加確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] MANAGE_AND_SYSTEM_READ権限の動作を実機で確認
- [ ] 機密情報（パスワード等）がマスクされることを確認
- [ ] 各タブの表示内容が設計書と一致することを確認
- [ ] スレッドダンプタブが非管理者には表示されないことを確認
