---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：32-負荷統計

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **グラフ自動更新の詳細間隔**：JavaScriptの更新間隔の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/jenkins/model/Jenkins/load-statistics.jelly`（行25-35）
- E-02: `core/src/main/java/jenkins/management/StatisticsLink.java`（行37-71）
- E-03: `core/src/main/resources/hudson/model/LoadStatistics/main.jelly`（行27-56）
- E-04: `core/src/main/java/hudson/model/OverallLoadStatistics.java`（行43-76）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行33）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行80-81）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLが`/manage/load-statistics`である | E-02（行63-64: `getUrlName()`が"load-statistics"を返す） | ○ |
| C-02 | MANAGE権限でアクセス制御される | E-02（行57-58: `return Jenkins.MANAGE`） | ○ |
| C-03 | Timespan選択肢がShort/Medium/Longである | E-03（行36-40: select要素内のoption） | ○ |
| C-04 | Mediumがデフォルト選択である | E-03（行38: `selected="true"`） | ○ |
| C-05 | グラフがdiv要素で動的描画される | E-03（行44-48: `class="js-load-graph"`） | ○ |
| C-06 | noscript時に静的画像が表示される | E-03（行49-52: noscript内のimg要素） | ○ |
| C-07 | Retina対応で2倍解像度画像が提供される | E-03（行51: `srcset`属性に`scale=2`） | ○ |
| C-08 | グラフAPIのパスが`loadStatistics/graph`である | E-03（行46, 51: `data-graph-base-url`と`src`属性） | ○ |
| C-09 | LoadStatistics.adjunctが読み込まれる | E-03（行28: `st:adjunct includes="hudson.model.LoadStatistics.resources"`) | ○ |
| C-10 | 画面カテゴリがSTATUSである | E-02（行68-70: `return Category.STATUS`) | ○ |
| C-11 | StatisticsLinkがManagementLinkを継承している | E-02（行38: `extends ManagementLink`) | ○ |
| C-12 | アイコンがsymbol-analyticsである | E-02（行41-43: `return "symbol-analytics"`) | ○ |
| C-13 | OverallLoadStatisticsがLoadStatisticsを継承している | E-04（行43: `extends LoadStatistics`) | ○ |
| C-14 | createOverallTrendChartメソッドが存在する | E-04（行73-75） | ○ |
| C-15 | 統計データにbusyExecutors、onlineExecutors、queueLength、availableExecutorsが含まれる | E-04（行74: `createTrendChart`の引数） | ○ |
| C-16 | load-statistics.jellyがmain.jellyをインクルードする | E-01（行33: `st:include page="main.jelly"`) | ○ |
| C-17 | prefixが"overallLoad"に設定される | E-01（行32: `j:set var="prefix" value="overallLoad"`) | ○ |
| C-18 | itがappに再設定される | E-01（行30: `j:set var="it" value="${app}"`) | ○ |
| C-19 | 関連機能がロード統計とエグゼキューターである | E-06（行80-81） | ○ |
| C-20 | 画面Noが32である | E-05（行33） | ○ |
| C-21 | l:settings-subpageでレイアウトされる | E-01（行29: `l:settings-subpage`) | ○ |
| C-22 | グラフ自動更新の詳細間隔 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- グラフ自動更新の詳細間隔
  - 候補：`resources.js`の実装 / `jenkins-js-modules`のグラフライブラリ / Jenkins UIドキュメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：権限チェックの実装（コードで明確に確認済み）
- 0（低リスク）：Timespan選択機能（Jellyテンプレートで明確に定義）
- 1（中リスク）：グラフ自動更新間隔（JavaScript実装の追加確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] MANAGE権限の動作を実機で確認
- [ ] 各Timespanでグラフが正しく切り替わることを確認
- [ ] グラフに4つの系列（Busy/Online/Queue/Available）が表示されることを確認
- [ ] JavaScript無効時に静的画像が表示されることを確認
