---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：33-スレッドダンプ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **タイムアウト処理の詳細実装**：`getAllThreadDumps()`のタイムアウト値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/jenkins/model/Jenkins/threadDump.jelly`（行29-63）
- E-02: `core/src/main/java/jenkins/model/Jenkins.java`（行4210-4230: `getAllThreadDumps()`メソッド）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行34）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行82）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLが`/threadDump`である | E-02（行4201: `rsp.sendRedirect2("threadDump")`） | ○ |
| C-02 | ADMINISTER権限でアクセス制御される | E-01（行30: `permission="${app.ADMINISTER}"`） | ○ |
| C-03 | getAllThreadDumps()で全ノードのスレッドダンプを取得 | E-01（行34: `it.getAllThreadDumps()`) | ○ |
| C-04 | 戻り値がMap形式である | E-02（行4210: `Map<String, Map<String, String>>`） | ○ |
| C-05 | ノードリンクがページ内アンカーである | E-01（行38: `href="#id${e.key.hashCode()}"`) | ○ |
| C-06 | ノードアイコンがsymbol-computerである | E-01（行38: `src="symbol-computer"`) | ○ |
| C-07 | 各ノード間に水平線（hr）が表示される | E-01（行46: `hr style="margin-bottom:6em"`) | ○ |
| C-08 | ノード見出しにidが設定される | E-01（行49: `id="id${e.key.hashCode()}"`) | ○ |
| C-09 | ノード名がノード詳細ページへのリンクになる | E-01（行50: `href="${rootURL}/computer/${e.key}/"`) | ○ |
| C-10 | スレッドダンプはpre要素で表示される | E-01（行58: `pre`要素） | ○ |
| C-11 | l:copyButtonでコピー機能が提供される | E-01（行56-57: `l:copyButton`） | ○ |
| C-12 | 画面タイトルがthreadDumpである | E-01（行30, 31: `title="${%threadDump}"`, `l:breadcrumb`） | ○ |
| C-13 | h1要素で見出しが表示される | E-01（行33, 49: `h1`要素） | ○ |
| C-14 | h2要素でスレッド名が表示される | E-01（行54: `h2`要素） | ○ |
| C-15 | 最初のノード以外はhr区切りが入る | E-01（行45: `j:if test="${!loop.first}"`) | ○ |
| C-16 | 空のノード名はスキップされる | E-01（行37, 48: `e.key != null and e.key.length() > 0`) | ○ |
| C-17 | model-linkクラスが使用される | E-01（行50: `class="model-link inside"`) | ○ |
| C-18 | 関連機能がJenkins本体である | E-04（行82） | ○ |
| C-19 | 画面Noが33である | E-03（行34） | ○ |
| C-20 | タイムアウト処理の詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- タイムアウト処理の詳細実装
  - 候補：`Jenkins.getAllThreadDumps()`の完全な実装 / `RemotingDiagnostics.java` / Jenkinsドキュメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：権限チェックの実装（コードで明確に確認済み）
- 0（低リスク）：表示形式（Jellyテンプレートで明確に定義）
- 1（中リスク）：タイムアウト処理（エージェントハング時の動作確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] ADMINISTER権限の動作を実機で確認
- [ ] 複数エージェント環境でスレッドダンプが正しく取得されることを確認
- [ ] コピーボタンが機能することを確認
- [ ] ノードリンクがページ内スクロールとして機能することを確認
