---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：34-再起動

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **再起動不可時の具体的な環境条件**：Lifecycle実装クラスの詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/jenkins/model/Jenkins/_restart.jelly`（行27-45）
- E-02: `core/src/main/java/jenkins/model/Jenkins.java`（行4546-4560: `doRestart()`メソッド）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行35）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行83）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLが`/restart`である | E-01（行34: `action="restart"`） | ○ |
| C-02 | GETリクエストで確認画面を表示 | E-02（行4548: `req.getMethod().equals("GET")`） | ○ |
| C-03 | POSTリクエストで再起動実行 | E-01（行34: `method="post"`） | ○ |
| C-04 | MANAGE権限でアクセス制御される | E-02（行4547: `checkPermission(MANAGE)`） | ○ |
| C-05 | canRestart()で再起動可否を確認 | E-01（行33: `app.lifecycle.canRestart()`） | ○ |
| C-06 | 再起動可能時にフォームが表示される | E-01（行33-38: `j:when test`とform要素） | ○ |
| C-07 | 再起動不可時にエラーメッセージが表示される | E-01（行39-41: `j:otherwise`） | ○ |
| C-08 | 確認メッセージが表示される | E-01（行35: `${%Are you sure you want to restart Jenkins?}`） | ○ |
| C-09 | Yesボタンでsubmitする | E-01（行36: `f:submit value="${%Yes}"`） | ○ |
| C-10 | sidepanel.jellyがインクルードされる | E-01（行29: `st:include page="sidepanel.jelly"`） | ○ |
| C-11 | 画面タイトルが"Restart Jenkins"である | E-01（行28: `title="${%Restart Jenkins}"`） | ○ |
| C-12 | パンくずリストに"Restart"が表示される | E-01（行30: `l:breadcrumb title="${%Restart}"`） | ○ |
| C-13 | _restart.jellyにフォワードされる | E-02（行4549: `"_restart.jelly"`） | ○ |
| C-14 | エラーメッセージの内容 | E-01（行40: `${%Jenkins cannot restart itself as currently configured.}`） | ○ |
| C-15 | 関連機能がJenkins本体である | E-04（行83） | ○ |
| C-16 | 画面Noが34である | E-03（行35） | ○ |
| C-17 | l:main-panelでメインコンテンツを表示 | E-01（行31: `l:main-panel`） | ○ |
| C-18 | 再起動不可時の具体的な環境条件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 再起動不可時の具体的な環境条件
  - 候補：`Lifecycle.java`のサブクラス実装 / `UnixLifecycle.java` / `WindowsLifecycle.java` / Jenkinsドキュメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：権限チェックの実装（コードで明確に確認済み）
- 0（低リスク）：表示分岐（Jellyテンプレートで明確に定義）
- 1（中リスク）：再起動不可環境の把握（Lifecycle実装の追加確認推奨）
- 2（高リスク）：実行中ビルドへの影響（即時再起動のため）

## 6) レビュアーチェックリスト（最小）
- [ ] MANAGE権限の動作を実機で確認
- [ ] 再起動可能環境でフォームが表示されることを確認
- [ ] Yesボタンで実際に再起動が実行されることを確認
- [ ] 再起動後にJenkinsが正常に起動することを確認
