---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：35-安全な再起動

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **ジョブ完了待機のタイムアウト処理**：無限待機となる可能性の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/jenkins/model/Jenkins/_safeRestart.jelly`（行27-56）
- E-02: `core/src/main/java/jenkins/model/Jenkins.java`（行4600-4615: `doSafeRestart()`、行4683-4695: `safeRestart()`、行5984-6012: `QuietDownInfo`）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行36）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行84-85）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLが`/safeRestart`である | E-01（行37: `action="safeRestart"`） | ○ |
| C-02 | GETリクエストで画面を表示 | E-02（行4602-4603: `forwardToView`） | ○ |
| C-03 | POSTリクエストで再起動/キャンセル実行 | E-01（行37: `method="post"`） | ○ |
| C-04 | MANAGE権限でアクセス制御される | E-02（行4601: `checkPermission(MANAGE)`） | ○ |
| C-05 | canRestart()で再起動可否を確認 | E-01（行34: `app.lifecycle.canRestart()`） | ○ |
| C-06 | メッセージ入力欄がある | E-01（行38-41: `f:textbox name="message"`） | ○ |
| C-07 | 既存のquietDownReasonが初期値になる | E-01（行40: `value="${app.quietDownReason ?: null}"`） | ○ |
| C-08 | Restartボタンがdestructive colorである | E-01（行43: `clazz="jenkins-!-destructive-color"`） | ○ |
| C-09 | クワイエットダウン中のみCancelボタンが表示される | E-01（行44-46: `j:if test="${app.isQuietingDown()}"`） | ○ |
| C-10 | Cancelボタンのname属性がcancelである | E-01（行45: `name="cancel"`） | ○ |
| C-11 | cancelパラメータでdoCancelQuietDown()が呼ばれる | E-02（行4606-4608: `getParameter("cancel") != null`） | ○ |
| C-12 | safeRestart(message)が呼び出される | E-02（行4611: `safeRestart(message)`） | ○ |
| C-13 | QuietDownInfoにmessageとsafeRestartフラグが設定される | E-02（行4686: `new QuietDownInfo(message, true)`） | ○ |
| C-14 | 新スレッド"safe-restart thread"が作成される | E-02（行4688: `new Thread("safe-restart thread")`） | ○ |
| C-15 | 画面タイトルが"Safe restart"である | E-01（行28, 32: `title="${%Safe restart}"`） | ○ |
| C-16 | l:app-barでタイトル表示 | E-01（行32: `l:app-bar title="${%Safe restart}"`） | ○ |
| C-17 | restartWarningメッセージが表示される | E-01（行35: `${%restartWarning}`） | ○ |
| C-18 | 再起動不可時はエラーメッセージ表示 | E-01（行50-51: `j:otherwise`、`${%cannotRestart}`） | ○ |
| C-19 | f:bottomButtonBarでボタンを配置 | E-01（行42: `f:bottomButtonBar`） | ○ |
| C-20 | HttpResponses.redirectToDot()を返す | E-02（行4614: `HttpResponses.redirectToDot()`） | ○ |
| C-21 | 関連機能がJenkins本体とキュー管理である | E-04（行84-85） | ○ |
| C-22 | 画面Noが35である | E-03（行36） | ○ |
| C-23 | f:entryでフォーム項目を構成 | E-01（行38: `f:entry`） | ○ |
| C-24 | ジョブ完了待機のタイムアウト処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ジョブ完了待機のタイムアウト処理
  - 候補：`safeRestart()`メソッドの完全な実装 / システムプロパティ設定 / Jenkinsドキュメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：権限チェックの実装（コードで明確に確認済み）
- 0（低リスク）：フォーム構成（Jellyテンプレートで明確に定義）
- 1（中リスク）：ジョブ完了待機のタイムアウト（長時間ジョブがある場合の動作確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] MANAGE権限の動作を実機で確認
- [ ] メッセージが入力できることを確認
- [ ] クワイエットダウン中にCancelボタンが表示されることを確認
- [ ] 実行中ジョブ完了後に再起動が実行されることを確認
- [ ] バナーメッセージがユーザーに表示されることを確認
