---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：36-Jenkinsについて

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **licenses.xmlの完全な構造**：XML形式の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/hudson/AboutJenkins/index.jelly`（行27-144）
- E-02: `core/src/main/java/hudson/AboutJenkins.java`（行17-55）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行37）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行86）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLが`/about`である | E-02（行25-27: `getUrlName()`が"about"を返す） | ○ |
| C-02 | READ権限でアクセス可能 | E-02（行45-47: `return Jenkins.READ`） | ○ |
| C-03 | MANAGE_AND_SYSTEM_READで画面表示が制御される | E-01（行47-49: `permissions="${app.MANAGE_AND_SYSTEM_READ}"`） | ○ |
| C-04 | app.VERSIONでバージョンを表示 | E-01（行34: `${app.VERSION}`） | ○ |
| C-05 | Get involvedボタンがある | E-01（行38-41: `class="jenkins-button"`、テキスト"Get involved"） | ○ |
| C-06 | Get involvedボタンにハートアイコンがある | E-01（行39: `src="symbol-heart"`） | ○ |
| C-07 | jenkins.io/participate/にリンクする | E-01（行38: `href="https://www.jenkins.io/participate/"`） | ○ |
| C-08 | Jenkinsロゴが表示される | E-01（行54: `src="${imagesURL}/svgs/logo.svg"`） | ○ |
| C-09 | オーロラ背景効果がある | E-01（行53: `class="app-about-branding__aurora"`） | ○ |
| C-10 | Maven依存タブがある | E-01（行60: `class="jenkins-tab-pane__title"`) | ○ |
| C-11 | licensesURLからライセンス情報を取得 | E-01（行61: `j:set var="uri" value="${it.licensesURL}"`） | ○ |
| C-12 | getLicensesURL()が/META-INF/licenses.xmlを返す | E-02（行40-42: `return AboutJenkins.class.getResource("/META-INF/licenses.xml")`） | ○ |
| C-13 | ライセンス情報がない場合「No information recorded」を表示 | E-01（行69: `${%No information recorded}`） | ○ |
| C-14 | 静的依存タブがある | E-01（行75: `class="jenkins-tab-pane__title"`) | ○ |
| C-15 | Jenkins Contrib Themesが静的依存に含まれる | E-01（行87-96: テーブル行） | ○ |
| C-16 | Ioniconsが静的依存に含まれる | E-01（行98-111: テーブル行） | ○ |
| C-17 | プラグイン依存タブがある | E-01（行116: `class="jenkins-tab-pane__title"`) | ○ |
| C-18 | app.pluginManager.pluginsからプラグイン一覧を取得 | E-01（行124: `j:forEach var="p" items="${app.pluginManager.plugins}"`) | ○ |
| C-19 | 非アクティブプラグインは取り消し線で表示 | E-01（行133: `strike`要素） | ○ |
| C-20 | プラグインのthirdPartyLicensesにリンク | E-01（行127: `href="${rootURL}/plugin/${p.shortName}/wrapper/thirdPartyLicenses"`） | ○ |
| C-21 | section-to-tabs.jsが読み込まれる | E-01（行50: `src="${resURL}/jsbundles/section-to-tabs.js"`) | ○ |
| C-22 | sortableテーブルが使用される | E-01（行76, 117: `class="jenkins-table sortable"`) | ○ |
| C-23 | カテゴリがSTATUSである | E-02（行51-53: `return Category.STATUS`) | ○ |
| C-24 | AboutJenkinsがManagementLinkを継承 | E-02（行18: `extends ManagementLink`) | ○ |
| C-25 | 画面Noが36である | E-03（行37） | ○ |
| C-26 | licenses.xmlの完全な構造 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- licenses.xmlの完全な構造
  - 候補：`/META-INF/licenses.xml`の実ファイル / Mavenプラグイン設定 / ビルドドキュメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：権限チェックの実装（コードで明確に確認済み）
- 0（低リスク）：タブ構成（Jellyテンプレートで明確に定義）
- 0（低リスク）：静的依存ライブラリ（ハードコードで明確）
- 1（中リスク）：Maven依存ライブラリ（licenses.xml生成の確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] READ権限でアクセスできることを確認
- [ ] Jenkinsバージョンが正しく表示されることを確認
- [ ] Maven依存タブにライブラリ一覧が表示されることを確認
- [ ] Get involvedボタンがjenkins.io/participateに遷移することを確認
- [ ] 非アクティブプラグインが取り消し線で表示されることを確認
