---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-プラグイン管理トップ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/hudson/PluginManager/index.jelly`（行25-34）
- E-02: `core/src/main/resources/hudson/PluginManager/sidepanel.jelly`（行29-42）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行38）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行87-88）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | local:updatesタグが使用される | E-01（行26: `xmlns:local="/hudson/PluginManager"`） | ○ |
| C-02 | updateCenter.jobsで条件分岐する | E-01（行28: `j:if test="${!empty(app.updateCenter.jobs)}"`） | ○ |
| C-03 | 更新センターへのリンクが表示される | E-01（行29-31: UpdatePageLegend） | ○ |
| C-04 | サイドパネルがstickyである | E-02（行30: `sticky="true"`） | ○ |
| C-05 | サイドパネルタイトルがPluginsである | E-02（行31: `title="${%Plugins}"`） | ○ |
| C-06 | Updatesリンクがある | E-02（行33: `title="${%Updates}"`） | ○ |
| C-07 | Updatesにbadgeがある | E-02（行33: `badge="${app.updateCenter.badge}"`） | ○ |
| C-08 | Updatesのアイコンがsymbol-downloadである | E-02（行33: `icon="symbol-download"`） | ○ |
| C-09 | Available pluginsリンクがある | E-02（行34: `title="${%Available plugins}"`） | ○ |
| C-10 | Available pluginsのアイコンがsymbol-shopping-bagである | E-02（行34: `icon="symbol-shopping-bag"`） | ○ |
| C-11 | Installed pluginsリンクがある | E-02（行35: `title="${%Installed plugins}"`） | ○ |
| C-12 | Installed pluginsのアイコンがsymbol-pluginsである | E-02（行35: `icon="symbol-plugins"`） | ○ |
| C-13 | Advanced settingsリンクがある | E-02（行36: `title="${%Advanced settings}"`） | ○ |
| C-14 | Advanced settingsのアイコンがsymbol-settingsである | E-02（行36: `icon="symbol-settings"`） | ○ |
| C-15 | Download progressリンクは条件付き | E-02（行37: `j:if test="${!app.updateCenter.jobs.isEmpty()}"`） | ○ |
| C-16 | Download progressのアイコンがsymbol-listである | E-02（行38: `icon="symbol-list"`） | ○ |
| C-17 | Updatesの遷移先が/manage/pluginManager/である | E-02（行33: `href="${rootURL}/manage/pluginManager/"`） | ○ |
| C-18 | Available pluginsの遷移先が/available | E-02（行34: `href="${rootURL}/manage/pluginManager/available"`） | ○ |
| C-19 | 関連機能がプラグインマネージャーとアップデートセンターである | E-04（行87-88） | ○ |
| C-20 | 画面Noが37である | E-03（行38） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全ての主張にコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] サイドパネルの各リンクが正しく遷移することを確認
- [ ] Updatesバッジに更新可能プラグイン数が表示されることを確認
- [ ] ダウンロードジョブがある場合にDownload progressリンクが表示されることを確認
