---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：38-インストール済みプラグイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **JavaScriptファイルの詳細実装**：_table.jsと_installed.jsの確認が必要
  2. **POSTリクエストのAPI仕様**：有効/無効切替APIの詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/hudson/PluginManager/installed.jelly`（行29-315）
- E-02: `core/src/main/java/hudson/PluginManager.java`（行205-300）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行39）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行89-90）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLが`/manage/pluginManager/installed`である | E-03（行39） | ○ |
| C-02 | SYSTEM_READ権限でアクセス可能 | E-01（行30: `permission="${app.SYSTEM_READ}"`） | ○ |
| C-03 | readOnlyModeがADMINISTER権限で判定される | E-01（行31: `!app.hasPermission(app.ADMINISTER)`） | ○ |
| C-04 | 検索ボックスがある | E-01（行42-47: `l:search-bar id="filter-box"`） | ○ |
| C-05 | 再起動必要時に警告が表示される | E-01（行56-58: `jenkins-alert-warning`） | ○ |
| C-06 | isRestartRequiredForCompletionで判定する | E-01（行54, 56: `app.updateCenter.isRestartRequiredForCompletion()`） | ○ |
| C-07 | プラグインがない場合「No plugins installed」を表示 | E-01（行74: `l:notice`） | ○ |
| C-08 | テーブルがソート可能 | E-01（行77: `class="jenkins-table sortable"`） | ○ |
| C-09 | 健全性スコア列が条件付き表示 | E-01（行81-88: `j:if test="${app.updateCenter.healthScoresAvailable}"`） | ○ |
| C-10 | Enabled列がある | E-01（行89: `${%Enabled}`） | ○ |
| C-11 | pluginsSortedByTitleでループ | E-01（行96: `items="${app.pluginManager.pluginsSortedByTitle}"`） | ○ |
| C-12 | プラグイン名が外部リンク | E-01（行102: `target="_blank" rel="noopener noreferrer"`） | ○ |
| C-13 | バージョンがラベル表示される | E-01（行104-107: `jenkins-label--tertiary`） | ○ |
| C-14 | mandatoryDependenciesが表示される | E-01（行110-116: `p.mandatoryDependencies`） | ○ |
| C-15 | イシュートラッカーリンクがある | E-01（行139-146: `p.getIssueTrackerReportUrl()`） | ○ |
| C-16 | セキュリティ警告が表示される | E-01（行147-159: `p.getActiveWarnings()`） | ○ |
| C-17 | 非推奨警告が表示される | E-01（行160-165: `p.isDeprecated()`） | ○ |
| C-18 | 引き継ぎ募集が表示される | E-01（行166-170: `hasAdoptThisPluginLabel`） | ○ |
| C-19 | 健全性スコアがバッジ表示される | E-01（行177-178: `jenkins-healthScore--badge`） | ○ |
| C-20 | トグルスイッチで有効/無効切替 | E-01（行191-198: `jenkins-toggle-switch`、`plugin-manager-toggle-switch`） | ○ |
| C-21 | readOnlyModeでトグルが無効化される | E-01（行195: `disabled="${readOnlyMode ? 'true' : null}"`） | ○ |
| C-22 | ダウングレードボタンが条件付き表示 | E-01（行204-218: `j:if test="${p.downgradable}"`） | ○ |
| C-23 | アンインストールボタンがある | E-01（行250-257: `data-action="uninstall"`） | ○ |
| C-24 | アンインストール済みは「Uninstallation pending」表示 | E-01（行226: `${%Uninstallation pending}`） | ○ |
| C-25 | 失敗したプラグインが表示される | E-01（行266-296: `it.failedPlugins`） | ○ |
| C-26 | 再起動ボタンが表示される | E-01（行303-309: `s:submit value="${%Restart Once No Jobs Are Running}"`） | ○ |
| C-27 | 関連機能がプラグインマネージャーと拡張機構である | E-04（行89-90） | ○ |
| C-28 | 画面Noが38である | E-03（行39） | ○ |
| C-29 | JavaScriptファイル_table.jsの詳細実装 | **根拠なし** | △ |
| C-30 | 有効/無効切替APIの詳細仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- JavaScriptファイルの詳細実装
  - 候補：`_table/`ディレクトリ内のJavaScript / `_installed/`ディレクトリ内のJavaScript
- 有効/無効切替APIの詳細仕様
  - 候補：`PluginManager.java`のdoメソッド / Stapler APIドキュメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：権限チェックの実装（コードで明確に確認済み）
- 0（低リスク）：テーブル構成（Jellyテンプレートで明確に定義）
- 1（中リスク）：JavaScript動作（クライアントサイドの追加確認推奨）
- 2（高リスク）：アンインストール操作（破壊的操作のため慎重に）

## 6) レビュアーチェックリスト（最小）
- [ ] SYSTEM_READ権限で一覧表示のみできることを確認
- [ ] ADMINISTER権限で操作ボタンが有効になることを確認
- [ ] 検索フィルタリングが機能することを確認
- [ ] トグルスイッチで有効/無効が切り替わることを確認
- [ ] 依存関係のあるプラグインの無効化が制限されることを確認
- [ ] セキュリティ警告が正しく表示されることを確認
