---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：39-利用可能なプラグイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **plugin-manager-ui.jsの詳細実装**：JavaScriptによる動的描画の確認が必要
  2. **UpdateCenter APIの仕様**：REST API仕様の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/hudson/PluginManager/available.jelly`（行28-102）
- E-02: `core/src/main/java/hudson/PluginManager.java`（行205-300）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行40）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行91-92）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLが`/manage/pluginManager/available`である | E-03（行40） | ○ |
| C-02 | SYSTEM_READ権限でアクセス可能 | E-01（行30: `permission="${app.SYSTEM_READ}"`） | ○ |
| C-03 | 検索ボックスがある | E-01（行37-41: `l:search-bar id="filter-box"`） | ○ |
| C-04 | Installボタンがスプリットボタンである | E-01（行45-65: `jenkins-split-button`） | ○ |
| C-05 | dynamicLoadパラメータで即時インストール | E-01（行46: `name="dynamicLoad"`） | ○ |
| C-06 | Install after restartがドロップダウン | E-01（行52-63: `l:overflowButton`） | ○ |
| C-07 | check.jellyがインクルードされる | E-01（行67: `st:include page="check.jelly"`） | ○ |
| C-08 | plugin-manager-ui.jsが読み込まれる | E-01（行71: `src="${resURL}/jsbundles/plugin-manager-ui.js"`） | ○ |
| C-09 | フォームのactionがinstallである | E-01（行73: `action="install"`） | ○ |
| C-10 | テーブルがソート可能 | E-01（行74: `class="jenkins-table sortable"`） | ○ |
| C-11 | hasAdminとhealthのdata属性がある | E-01（行75-76: `data-hasAdmin`, `data-health`） | ○ |
| C-12 | Install列が管理者のみ | E-01（行79-83: `l:isAdmin`） | ○ |
| C-13 | Name列がある | E-01（行84: `${%Name}`） | ○ |
| C-14 | Released列がある | E-01（行85: `${%Released}`） | ○ |
| C-15 | Health列が条件付き表示 | E-01（行86-93: `j:if test="${app.updateCenter.healthScoresAvailable}"`） | ○ |
| C-16 | healthTooltipがツールチップ表示 | E-01（行89-90: `data-html-tooltip`, `data-tooltip-interactive`） | ○ |
| C-17 | tbodyが空である | E-01（行96: `<tbody/>`） | ○ |
| C-18 | Installボタンにdownloadアイコン | E-01（行47-49: `symbol-download`） | ○ |
| C-19 | 関連機能がプラグインマネージャーとアップデートセンターである | E-04（行91-92） | ○ |
| C-20 | 画面Noが39である | E-03（行40） | ○ |
| C-21 | plugin-manager-ui.jsの詳細実装 | **根拠なし** | △ |
| C-22 | UpdateCenter APIの仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- plugin-manager-ui.jsの詳細実装
  - 候補：`war/src/main/js/`ディレクトリ / Jenkins UIドキュメント
- UpdateCenter APIの仕様
  - 候補：`UpdateCenter.java`のdoメソッド / REST APIドキュメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：権限チェックの実装（コードで明確に確認済み）
- 0（低リスク）：テーブル構造（Jellyテンプレートで明確に定義）
- 1（中リスク）：JavaScript動的描画（クライアントサイドの追加確認推奨）
- 1（中リスク）：プラグインインストール処理（依存関係解決の確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] SYSTEM_READ権限で一覧表示のみできることを確認
- [ ] ADMINISTER権限でInstallボタンが有効になることを確認
- [ ] 検索フィルタリングが機能することを確認
- [ ] Installボタンでプラグインがインストールされることを確認
- [ ] 健全性スコアが正しく表示されることを確認
- [ ] Check nowボタンで更新サイトが確認されることを確認
