---
generated_at: 2026-01-22 19:36:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：4-ログイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Remember Meトークンの保存方式**：永続化の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/jenkins/model/Jenkins/login.jelly`
- E-02: `core/src/main/java/hudson/security/SecurityRealm.java`
- E-03: `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ログイン画面でユーザー認証を行う | E-01, E-04 | ○ |
| C-02 | URLは/login | E-01 | ○ |
| C-03 | j_usernameとj_passwordフィールドがある | E-01 (89, 104行目) | ○ |
| C-04 | remember_meチェックボックスがある | E-01 (111-114行目) | ○ |
| C-05 | Remember Meは条件付きで表示 | E-01 (108行目) | ○ |
| C-06 | CSRF対策のCrumbトークンが含まれる | E-01 (119行目) | ○ |
| C-07 | キャッシュ制御ヘッダーが設定される | E-01 (29-30行目) | ○ |
| C-08 | NOFOLLOWメタタグがある | E-01 (58行目) | ○ |
| C-09 | authenticationGatewayUrlにPOST | E-01 (77行目) | ○ |
| C-10 | セルフサインアップリンクは条件付き表示 | E-01 (125行目) | ○ |
| C-11 | エラー時にinputClassがjenkins-input--error | E-01 (49行目) | ○ |
| C-12 | セットアップウィザード中は別画面表示 | E-01 (66-68行目) | ○ |
| C-13 | フェデレーテッドログインが表示される | E-01 (132-136行目) | ○ |
| C-14 | from変数でリダイレクト先を保持 | E-01 (47, 118行目) | ○ |
| C-15 | セッションが生成される | E-01 (42行目) | ○ |
| C-16 | 認証失敗時にエラーメッセージ表示 | E-01 (79-83行目) | ○ |
| C-17 | 関連機能は認証(28)、CSRF保護(33) | E-05 | ○ |
| C-18 | ダッシュボードへ遷移可能 | E-06 (113行目) | ○ |
| C-19 | サインアップ画面へ遷移可能 | E-01 (127行目) | ○ |
| C-20 | autofocusがユーザー名フィールドに設定 | E-01 (94行目) | ○ |
| C-21 | Spring Securityフレームワークを使用 | E-02, E-03 | ○ |
| C-22 | Remember Meトークンの永続化方式 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Remember Meトークンの永続化詳細
  - 候補：`core/src/main/java/jenkins/security/RememberMeServicesImpl.java`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - セキュリティ関連の処理フローは明確
- 1: 中リスク - CSRF保護の具体的な検証処理の詳細確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 認証失敗時のエラーメッセージが適切か
- [ ] Remember Me機能の有効/無効条件が正確か
- [ ] セットアップウィザード時の分岐が正しいか
- [ ] CSRF保護が正しく機能しているか
