---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：40-更新可能なプラグイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **row-selection-controller.jsの詳細実装**：Compatible選択の具体的なロジック確認が必要
  2. **_tableアジャンクトの詳細実装**：テーブルフィルタリング・ソートの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/hudson/PluginManager/updates.jelly`（行27-262）
- E-02: `core/src/main/java/hudson/PluginManager.java`（行205-300）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行41）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行93-94）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLが`/manage/pluginManager/`である | E-03（行41） | ○ |
| C-02 | SYSTEM_READ権限でアクセス可能 | E-01（行27: `permission="${app.SYSTEM_READ}"`） | ○ |
| C-03 | 検索ボックスがある | E-01（行40-45: `l:search-bar id="filter-box"`） | ○ |
| C-04 | Updateボタンが初期disabled | E-01（行50: `disabled="true"`） | ○ |
| C-05 | Updateボタンにdownloadアイコン | E-01（行51: `symbol-download`） | ○ |
| C-06 | check.jellyがインクルードされる | E-01（行56: `st:include page="check.jelly"`） | ○ |
| C-07 | _tableアジャンクトが読み込まれる | E-01（行60: `st:adjunct includes="hudson.PluginManager._table"`） | ○ |
| C-08 | フォームのactionがinstallである | E-01（行62: `action="install"`） | ○ |
| C-09 | テーブルがソート可能 | E-01（行67: `class="jenkins-table sortable"`） | ○ |
| C-10 | rowSelectionControllerがある | E-01（行72: `l:rowSelectionController`） | ○ |
| C-11 | Compatibleボタンが条件付き表示 | E-01（行73: `j:if test="${app.updateCenter.hasIncompatibleUpdates(cache)}"`） | ○ |
| C-12 | Compatibleボタンにdata-select="compatible"属性 | E-01（行74: `data-select="compatible"`） | ○ |
| C-13 | Name列が降順ソート | E-01（行84: `initialSortDir="down"`） | ○ |
| C-14 | Released列がある | E-01（行85: `${%Released}`） | ○ |
| C-15 | Installed列がある | E-01（行86: `${%Installed}`） | ○ |
| C-16 | Health列が条件付き表示 | E-01（行87-94: `j:if test="${app.updateCenter.healthScoresAvailable}"`） | ○ |
| C-17 | healthTooltipがツールチップ表示 | E-01（行89-90: `data-html-tooltip`, `data-tooltip-interactive`） | ○ |
| C-18 | チェックボックスにdata-compat-warning属性 | E-01（行112: `data-compat-warning="${!p.isCompatible(cache)}"`） | ○ |
| C-19 | 更新済みプラグインがalready-upgradedクラス | E-01（行102: `class="${installJob!=null ? 'already-upgraded' : ''} plugin"`） | ○ |
| C-20 | プラグイン名が外部リンク | E-01（行121: `target="_blank" rel="noopener noreferrer"`） | ○ |
| C-21 | カテゴリバッジがある | E-01（行129-140: `p.categories.isEmpty()`判定） | ○ |
| C-22 | 互換性警告が表示される | E-01（行146-162: `!p.isCompatibleWithInstalledVersion()`判定） | ○ |
| C-23 | コア互換性警告が表示される | E-01（行163-165: `p.isForNewerHudson()`判定） | ○ |
| C-24 | セキュリティ脆弱性修正警告が表示される | E-01（行166-170: `p.fixesSecurityVulnerabilities()`判定） | ○ |
| C-25 | 依存関係互換性警告が表示される | E-01（行171-186: `!p.isNeededDependenciesCompatibleWithInstalledVersion(cache)`判定） | ○ |
| C-26 | セキュリティ警告が表示される | E-01（行192-204: `p.hasWarnings()`判定） | ○ |
| C-27 | 非推奨警告が表示される | E-01（行205-209: `p.isDeprecated()`判定） | ○ |
| C-28 | 引き継ぎ募集が表示される | E-01（行210-214: `it.hasAdoptThisPluginLabel(p)`判定） | ○ |
| C-29 | 非アクティブプラグインは括弧付きバージョン表示 | E-01（行224-234: `p.installed.active`判定） | ○ |
| C-30 | 更新がない場合「No updates available」表示 | E-01（行255: `l:notice icon="symbol-up-to-date" title="${%No updates available}"`） | ○ |
| C-31 | row-selection-controller.jsの詳細実装 | **根拠なし** | △ |
| C-32 | _tableアジャンクトの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- row-selection-controller.jsの詳細実装
  - 候補：`war/src/main/js/components/`ディレクトリ
- _tableアジャンクトの詳細実装
  - 候補：`core/src/main/resources/hudson/PluginManager/_table/`ディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：権限チェックの実装（コードで明確に確認済み）
- 0（低リスク）：テーブル構造（Jellyテンプレートで明確に定義）
- 0（低リスク）：警告メッセージ表示（条件分岐が明確）
- 1（中リスク）：JavaScript動作（行選択コントローラーの追加確認推奨）
- 2（高リスク）：プラグイン更新操作（互換性チェックの動作確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] SYSTEM_READ権限で一覧表示のみできることを確認
- [ ] ADMINISTER権限でUpdateボタンが有効になることを確認
- [ ] 検索フィルタリングが機能することを確認
- [ ] Compatibleボタンで互換性のある更新のみが選択されることを確認
- [ ] 互換性警告が正しく表示されることを確認
- [ ] セキュリティ脆弱性修正の警告が正しく表示されることを確認
- [ ] 更新済みプラグインのチェックボックスが無効化されることを確認
- [ ] Check nowボタンで更新サイトが確認されることを確認
