---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：41-プラグイン詳細設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **エラーメッセージの具体的な文言**：プロパティファイルで確認できない可能性
  2. **プラグインファイル形式検証の詳細**：Java側の検証ロジック詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/PluginManager/advanced.jelly` (行1-110)
- E-02: `core/src/main/resources/hudson/PluginManager/advanced.properties` (行1-28)
- E-03: `core/src/main/java/hudson/PluginManager.java` (行1-500)
- E-04: `core/src/main/java/hudson/model/UpdateCenter.java` (行1-500)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行95-96)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルは「Advanced settings - Plugins」 | E-01 (行31) | ○ |
| C-02 | SYSTEM_READ権限で画面閲覧可能 | E-01 (行31: `permission="${app.SYSTEM_READ}"`) | ○ |
| C-03 | ADMINISTER権限がない場合は読み取り専用モード | E-01 (行32: `readOnlyMode`変数) | ○ |
| C-04 | Deploy Pluginセクションが存在する | E-01 (行46-64) | ○ |
| C-05 | .hpi/.jpiファイル形式のアップロードが可能 | E-01 (行54: `accept=".hpi,.jpi"`) | ○ |
| C-06 | URLからのプラグインダウンロードが可能 | E-01 (行57-59: `pluginUrl`入力フィールド) | ○ |
| C-07 | Update Siteセクションが存在する | E-01 (行66-93) | ○ |
| C-08 | Reset to defaultリンクが存在する | E-01 (行72-73) | ○ |
| C-09 | フォームアクションはuploadPluginとsiteConfigure | E-01 (行49, 68) | ○ |
| C-10 | プロキシ設定が別画面に移動した旨の情報表示 | E-01 (行40-42), E-02 (行27) | ○ |
| C-11 | checkUpdateSiteUrlでURL検証を行う | E-01 (行78: `checkUrl="checkUpdateSiteUrl"`) | ○ |
| C-12 | checkPluginUrlでプラグインURL検証を行う | E-01 (行59: `checkUrl="checkPluginUrl"`) | ○ |
| C-13 | 関連機能はプラグインマネージャーとプロキシ設定 | E-05 | ○ |
| C-14 | ID_DEFAULTでデフォルトアップデートサイトを識別 | E-04 (行175-181) | ○ |
| C-15 | その他のサイトセクションは条件付き表示 | E-01 (行87-106: `hasNonDefault`変数) | ○ |
| C-16 | isAdmin条件でADMINISTER権限チェック | E-01 (行46, 70, 80-85) | ○ |
| C-17 | エラーメッセージ「Invalid plugin file」 | **根拠なし** | △ |
| C-18 | doUploadPluginとdoSiteConfigureメソッドの詳細仕様 | **根拠なし**（ファイルサイズ制限で一部未確認） | △ |

## 4) 不足情報（Unknown / Missing）

- **エラーメッセージの完全なリスト**：Javaソースコードとプロパティファイルの完全な確認が必要
  - 候補：PluginManager.java全体 / Messages.properties / エラーハンドリングロジック
- **doUploadPluginの詳細実装**：PluginManager.javaのファイルサイズが大きく、該当メソッドの完全な確認ができていない
  - 候補：PluginManager.java (500行以降)

## 5) リスクフラグ（レビュー観点）

- **リスク0（低）**: 画面構造、権限設定、フォームアクション名 - Jellyテンプレートから直接確認
- **リスク1（中）**: エラーメッセージの文言 - 実行時の動作確認推奨
- **リスク1（中）**: プラグインアップロード後の遷移先 - 実際の動作確認推奨

## 6) レビュアーチェックリスト（最小）

- [ ] ADMINISTER権限でDeploy Pluginセクションが表示されることを確認
- [ ] 読み取り専用モードで編集要素が非表示になることを確認
- [ ] Reset to defaultリンクの動作を確認
- [ ] プラグインアップロード後のUpdateCenter画面への遷移を確認
