---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：42-更新センター

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **AJAX更新処理の詳細**：JavaScriptファイルの直接確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/model/UpdateCenter/index.jelly` (行1-40)
- E-02: `core/src/main/resources/hudson/model/UpdateCenter/body.jelly` (行1-55)
- E-03: `core/src/main/java/hudson/model/UpdateCenter.java` (行1-500)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行97-98)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルは「Download progress - Plugins」 | E-01 (行31) | ○ |
| C-02 | SYSTEM_READ権限で画面閲覧可能 | E-01 (行31: `permission="${app.SYSTEM_READ}"`) | ○ |
| C-03 | body.jellyでジョブ一覧を表示 | E-01 (行37: `st:include page="body.jelly"`) | ○ |
| C-04 | 各ジョブにrow.jellyを使用 | E-02 (行35: `st:include page="row.jelly"`) | ○ |
| C-05 | Go back to the top pageリンクが存在 | E-02 (行42) | ○ |
| C-06 | 再起動スケジュールチェックボックスが存在 | E-02 (行48) | ○ |
| C-07 | isAdmin条件で再起動オプションを制御 | E-02 (行45: `l:isAdmin`) | ○ |
| C-08 | canRestart()で再起動サポートを確認 | E-02 (行46: `app.lifecycle.canRestart()`) | ○ |
| C-09 | AJAX更新領域にl:ajaxタグを使用 | E-02 (行31: `l:ajax`) | ○ |
| C-10 | jobsリストからジョブを取得 | E-02 (行34: `it.jobs`), E-03 (行202, 350-356) | ○ |
| C-11 | update-center.js adjunctをインクルード | E-01 (行32) | ○ |
| C-12 | _download-failure adjunctをインクルード | E-01 (行33) | ○ |
| C-13 | sidepanelはPluginManagerから継承 | E-01 (行34: `it="${app.pluginManager}"`) | ○ |
| C-14 | 関連機能はアップデートセンターとプラグインマネージャー | E-04 | ○ |
| C-15 | AJAX更新処理の詳細動作 | **根拠なし**（JavaScriptファイル未確認） | △ |

## 4) 不足情報（Unknown / Missing）

- **AJAX更新のJavaScript実装**：update-center.jsの実装詳細の確認が必要
  - 候補：core/src/main/resources/hudson/model/UpdateCenter/update-center.js

## 5) リスクフラグ（レビュー観点）

- **リスク0（低）**: 画面構造、権限設定、条件分岐 - Jellyテンプレートから直接確認
- **リスク1（中）**: AJAX更新の動作詳細 - JavaScriptファイルの確認推奨
- **リスク0（低）**: 再起動オプションの表示条件 - Jellyテンプレートから確認

## 6) レビュアーチェックリスト（最小）

- [ ] ジョブ一覧が正しく表示されることを確認
- [ ] AJAX更新が機能することを確認
- [ ] ADMINISTER権限で再起動オプションが表示されることを確認
- [ ] 再起動非サポート環境で再起動オプションが非表示になることを確認
