---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：43-ユーザー一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。レビュー優先度の高い項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/index.jelly` (行1-89)
- E-02: `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/index.properties` (行1-27)
- E-03: `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` (行1-1191)
- E-04: `core/src/main/java/hudson/model/User.java` (行1-1353)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行99-100)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルは「Users」とユーザー数を表示 | E-01 (行29: `title="${%Users}" subtitle="${it.allUsers.size()}"`) | ○ |
| C-02 | ADMINISTER権限で画面アクセス可能 | E-01 (行42: `permission="${app.ADMINISTER}"`) | ○ |
| C-03 | Create Userボタンが存在 | E-01 (行31-34) | ○ |
| C-04 | Create UserボタンはisAdmin条件付き | E-01 (行30: `l:isAdmin`) | ○ |
| C-05 | テーブルはソート可能 | E-01 (行43: `class="jenkins-table sortable"`) | ○ |
| C-06 | User IDカラムがデフォルトソートキー | E-01 (行47: `initialSortDir="down"`) | ○ |
| C-07 | アバターが64x64サイズで表示 | E-01 (行58: `getUserAvatar(user, '64x64')`) | ○ |
| C-08 | ユーザーIDはmodel-linkクラス付きリンク | E-01 (行62) | ○ |
| C-09 | 削除アイコンはcanDelete()で表示制御 | E-01 (行75: `j:if test="${user.canDelete()}"`) | ○ |
| C-10 | 削除はconfirmationLinkを使用 | E-01 (行77-79) | ○ |
| C-11 | 削除確認メッセージに表示名を含む | E-01 (行78), E-02 (行27) | ○ |
| C-12 | getAllUsers()でDetailsプロパティを持つユーザーを抽出 | E-03 (行591-602) | ○ |
| C-13 | canDelete()でADMINISTER権限をチェック | E-04 (行971-975) | ○ |
| C-14 | canDelete()で自分自身は削除不可 | E-04 (行973: `!strategy.equals(id, Jenkins.getAuthentication2().getName())`) | ○ |
| C-15 | canDelete()でgetUserFolder()!=nullをチェック | E-04 (行974) | ○ |
| C-16 | 説明文でasyncPeopleへのリンクを含む | E-02 (行23-26) | ○ |
| C-17 | 関連機能はユーザー管理と認可 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）

- 不足情報なし。すべての主張に対して根拠を確認できました。

## 5) リスクフラグ（レビュー観点）

- **リスク0（低）**: 画面構造、権限設定 - Jellyテンプレートから直接確認
- **リスク0（低）**: getAllUsers()ロジック - Javaソースから直接確認
- **リスク0（低）**: canDelete()ロジック - Javaソースから直接確認

## 6) レビュアーチェックリスト（最小）

- [ ] ユーザー一覧が正しく表示されることを確認
- [ ] Create Userボタンが機能することを確認
- [ ] 自分自身のアカウントに削除アイコンが表示されないことを確認
- [ ] 他ユーザーの削除確認ダイアログが正しく表示されることを確認
