---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：45-ユーザービルド一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。レビュー優先度の高い項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/model/User/builds.jelly` (行1-33)
- E-02: `core/src/main/java/hudson/model/User.java` (行764-787)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行103-104)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タイトルは「Builds for {displayName}」 | E-01 (行26: `title="${%Builds for(it.displayName)}"`) | ○ |
| C-02 | sidepanel.jellyをインクルード | E-01 (行27) | ○ |
| C-03 | t:projectViewでビルド一覧を表示 | E-01 (行30: `t:projectView builds="${it.builds}"`) | ○ |
| C-04 | t:rssBar-withAllでRSSリンクを表示 | E-01 (行31) | ○ |
| C-05 | getBuilds()でRunListを返す | E-02 (行784-787) | ○ |
| C-06 | RunList.fromJobsで全ジョブからビルドを取得 | E-02 (行785-786) | ○ |
| C-07 | relatedTo()でフィルタリング | E-02 (行786: `.filter((Predicate<Run<?, ?>>) this::relatedTo)`) | ○ |
| C-08 | relatedTo()でRunWithSCM.hasParticipantをチェック | E-02 (行765-766) | ○ |
| C-09 | relatedTo()でCause.UserIdCauseをチェック | E-02 (行768-775) | ○ |
| C-10 | UserIdCauseのgetUserId()でユーザーIDを取得 | E-02 (行770) | ○ |
| C-11 | idStrategy().equals()でユーザーID比較 | E-02 (行771) | ○ |
| C-12 | ビルド履歴はRSSフィードで提供（rssAll等） | E-02 (行935-957: doRssAll, doRssFailed, doRssLatest) | ○ |
| C-13 | 関連機能はビルドとユーザー管理 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）

- 不足情報なし。すべての主張に対して根拠を確認できました。

## 5) リスクフラグ（レビュー観点）

- **リスク0（低）**: 画面構造 - Jellyテンプレートから直接確認
- **リスク0（低）**: getBuilds()ロジック - Javaソースから直接確認
- **リスク0（低）**: relatedTo()の判定ロジック - Javaソースから直接確認

## 6) レビュアーチェックリスト（最小）

- [ ] ユーザーに関連するビルドが一覧表示されることを確認
- [ ] SCM変更ログに含まれるユーザーのビルドが表示されることを確認
- [ ] ユーザーがトリガーしたビルドが表示されることを確認
- [ ] RSSフィードリンクが機能することを確認
