---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-ユーザーセキュリティ設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。レビュー優先度の高い項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/model/userproperty/UserPropertyCategorySecurityAction.java` (行1-77)
- E-02: `core/src/main/java/hudson/model/userproperty/UserPropertyCategoryAction.java` (行1-65)
- E-03: `core/src/main/resources/hudson/model/userproperty/UserPropertyCategorySecurityAction/index.jelly` (行1-41)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行105-106)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは /user/{userId}/security | E-01 (行59-61: `getUrlName() return "security"`) | ○ |
| C-02 | ADMINISTER権限でアイコン表示 | E-01 (行54-56: `hasPermission(Jenkins.ADMINISTER)`) | ○ |
| C-03 | アイコンはsymbol-lock-closed | E-01 (行55: `"symbol-lock-closed"`) | ○ |
| C-04 | getMyCategoryDescriptorsでSecurityカテゴリ取得 | E-01 (行63-65: `allByCategoryClass(Security.class)`) | ○ |
| C-05 | Extension(ordinal = 200)で登録 | E-01 (行70: `@Extension(ordinal = 200)`) | ○ |
| C-06 | シンボル名はsecurity | E-01 (行71: `@Symbol("security")`) | ○ |
| C-07 | doConfigSubmitでフォーム処理 | E-02 (行33-64) | ○ |
| C-08 | doConfigSubmitはPOSTメソッド | E-02 (行33: `@POST`) | ○ |
| C-09 | checkPermission(ADMINISTER)で権限確認 | E-02 (行35: `this.targetUser.checkPermission(Jenkins.ADMINISTER)`) | ○ |
| C-10 | getMyCategoryDescriptors()をループ | E-02 (行42) | ○ |
| C-11 | reconfigure()またはnewInstance()を呼び出し | E-02 (行48, 50) | ○ |
| C-12 | addProperties()で一括更新 | E-02 (行58) | ○ |
| C-13 | save()で永続化 | E-02 (行60) | ○ |
| C-14 | FormApply.success("..")でリダイレクト | E-02 (行63) | ○ |
| C-15 | 関連機能はユーザー管理と認証 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）

- 不足情報なし。すべての主張に対して根拠を確認できました。

## 5) リスクフラグ（レビュー観点）

- **リスク0（低）**: アクションクラスの実装 - Javaソースから直接確認
- **リスク0（低）**: フォーム処理の流れ - 基底クラスから直接確認

## 6) レビュアーチェックリスト（最小）

- [ ] ADMINISTER権限でサイドパネルにSecurityリンクが表示されることを確認
- [ ] 非ADMINISTER権限でリンクが非表示になることを確認
- [ ] 設定保存後にユーザー詳細画面にリダイレクトされることを確認
