---
generated_at: 2026-01-22 19:38:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-ログインエラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/jenkins/model/Jenkins/loginError.jelly`
- E-02: `core/src/main/resources/jenkins/model/Jenkins/login.jelly`
- E-03: `core/src/main/java/hudson/Functions.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 認証失敗時に表示される | E-01, E-04 | ○ |
| C-02 | URLは/loginError | E-01 | ○ |
| C-03 | HTTPステータス401が返される | E-01 (35行目) | ○ |
| C-04 | login.jellyをerror=trueで再利用 | E-01 (36-37行目) | ○ |
| C-05 | セットアップウィザード中は別画面 | E-01 (30-33行目) | ○ |
| C-06 | 認証済みならダッシュボードへリダイレクト | E-01 (40行目) | ○ |
| C-07 | h.isAnonymous()で認証状態をチェック | E-01 (34行目) | ○ |
| C-08 | app.isUseSecurity()でセキュリティ有効をチェック | E-01 (34行目) | ○ |
| C-09 | エラーメッセージ"Invalid username or password" | E-02 (81行目) | ○ |
| C-10 | 入力フィールドにエラースタイルが適用 | E-02 (49行目) | ○ |
| C-11 | セッションからfromを取得 | E-02 (47行目) | ○ |
| C-12 | 関連機能は認証(28) | E-05 | ○ |
| C-13 | ログイン画面から遷移 | E-06 (114行目) | ○ |
| C-14 | ログイン画面へ戻って再試行可能 | E-06 (115行目) | ○ |
| C-15 | Functionsクラスのnewインスタンス作成 | E-01 (29行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな画面構成で、全ての処理フローがソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 401ステータスコードが正しく返されることを確認
- [ ] エラー状態のスタイル適用が正しいか
- [ ] セットアップウィザード時の分岐が正しいか
