---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：51-セットアップウィザード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **ウィザードUI（JavaScript）の詳細仕様**：フロントエンド実装の詳細は未確認
  2. **platform-plugins.jsonの内容**：ファイル存在は確認したが内容詳細は未検証
  3. **wizard-ui.jellyの構造**：参照はあるが内容詳細は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/install/SetupWizard.java` (801行)
- E-02: `core/src/main/resources/jenkins/install/SetupWizard/index.jelly` (11行)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (51行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (51行目関連)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` (セットアップフロー図)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セットアップウィザードはJenkins初回起動時に表示される | E-01 (142-145行目 `if (newInstall)`) | ○ |
| C-02 | URL は /setupWizard/ である | E-01 (778行目 `getContextPath() + "/setupWizard/"`) | ○ |
| C-03 | FORCE_SETUP_WIZARD_FILTERによりリダイレクトされる | E-01 (758-791行目) | ○ |
| C-04 | 初期管理パスワードはUUIDから生成される | E-01 (152行目 `UUID.randomUUID().toString().replace("-", "")`) | ○ |
| C-05 | パスワードファイルは secrets/initialAdminPassword に保存 | E-01 (688-689行目 `getRootPath().child("secrets/initialAdminPassword")`) | ○ |
| C-06 | パスワードファイルのパーミッションは0640 | E-01 (165行目 `iapf.chmod(0640)`) | ○ |
| C-07 | HudsonPrivateSecurityRealmが作成される | E-01 (150行目 `new HudsonPrivateSecurityRealm(false, false, null)`) | ○ |
| C-08 | FullControlOnceLoggedInAuthorizationStrategyが設定される | E-01 (170-172行目) | ○ |
| C-09 | JNLPポートはデフォルトで-1（無効） | E-01 (175行目 `setSlaveAgentPort(-1)`) | ○ |
| C-10 | CRUMBイシュアーがデフォルトで設定される | E-01 (178行目 `setCrumbIssuer()`) | ○ |
| C-11 | doCreateAdminUser() でユーザー作成を行う | E-01 (332-414行目) | ○ |
| C-12 | doConfigureInstance() でURL設定を行う | E-01 (416-444行目) | ○ |
| C-13 | doPlatformPluginList() でプラグインリストを取得 | E-01 (502-519行目) | ○ |
| C-14 | doCompleteInstall() でセットアップを完了 | E-01 (704-708行目) | ○ |
| C-15 | レイアウトタイプは full-screen | E-02 (4行目 `type="full-screen"`) | ○ |
| C-16 | plugin-setup-wizard-container クラスが使用される | E-02 (6行目) | ○ |
| C-17 | 関連機能は初期化フレームワーク(70)、プラグインマネージャー(2)、ユーザー管理(30) | E-04 | ○ |
| C-18 | InstallUtil.proceedToNextStateFrom()で状態遷移 | E-01 (376, 436, 714行目) | ○ |
| C-19 | 画面遷移図にセットアップウィザードフローが定義されている | E-05 (セットアップウィザードフロー) | ○ |
| C-20 | UpdateCenter.updateDefaultSite()が初期化時に呼ばれる | E-01 (208行目) | ○ |
| C-21 | ADMIN_INITIAL_API_TOKENプロパティでAPIトークン自動生成可能 | E-01 (103-131行目、157-159行目) | ○ |
| C-22 | ローカルの platform-plugins.json にフォールバックする | E-01 (616-624行目) | ○ |
| C-23 | PageDecoratorを拡張している | E-01 (89行目 `extends PageDecorator`) | ○ |
| C-24 | Jenkins.ADMINISTER権限が必要 | E-01 (337, 419, 554, 711行目 `checkPermission(Jenkins.ADMINISTER)`) | ○ |
| C-25 | ウィザードUIのJavaScript実装詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ウィザードUIのJavaScript実装詳細（wizard-ui関連）
  - 候補：`war/src/main/js/` / `war/src/main/less/` / フロントエンドアセット

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メインのバックエンド処理は十分にカバー
- 1: 中リスク - フロントエンド（JavaScript/CSS）の実装詳細が未検証
- 0: 低リスク - 画面遷移図との整合性確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] SetupWizard.javaのinit()メソッドの処理フローが正確に記述されているか確認
- [ ] FORCE_SETUP_WIZARD_FILTERの動作が実際の挙動と一致するか確認
- [ ] プラグインリスト取得のフォールバック処理が正しく説明されているか確認
- [ ] JavaScriptベースのウィザードUIの動作詳細を補足する必要があるか検討
- [ ] InstallStateの状態遷移図を追加する必要があるか検討
