---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-インスタンス設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/jenkins/install/SetupWizard/setupWizardConfigureInstance.jelly` (53行)
- E-02: `core/src/main/java/jenkins/install/SetupWizard.java` (416-459行)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (53行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (53行目関連)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フォームのアクションは /setupWizard/configureInstance | E-01 (30行目 `action="${rootURL}/setupWizard/configureInstance"`) | ○ |
| C-02 | norefresh="true"でレイアウト設定 | E-01 (27行目) | ○ |
| C-03 | タイトルは "Instance Configuration" | E-01 (31行目 `${%Instance Configuration}`) | ○ |
| C-04 | root-url入力フィールドが存在 | E-01 (37行目 `id="root-url"`) | ○ |
| C-05 | setInitialRootUrlFieldValueアジャンクトを使用 | E-01 (48行目) | ○ |
| C-06 | doConfigureInstance()でインスタンス設定処理 | E-02 (416-444行目) | ○ |
| C-07 | Jenkins.ADMINISTER権限が必要 | E-02 (419行目 `Jenkins.get().checkPermission(Jenkins.ADMINISTER)`) | ○ |
| C-08 | checkRootUrl()でURL検証 | E-02 (423行目, 446-454行目) | ○ |
| C-09 | URL空チェックを実行 | E-02 (447-449行目 `if (rootUrl == null)`) | ○ |
| C-10 | UrlHelper.isValidRootUrl()で形式検証 | E-02 (451-453行目) | ○ |
| C-11 | エラー時はエラーJSONレスポンスを返却 | E-02 (425-427行目 `HttpResponses.errorJSON()`) | ○ |
| C-12 | useRootUrl()でURL適用 | E-02 (430行目, 456-459行目) | ○ |
| C-13 | JenkinsLocationConfiguration.setUrl()で保存 | E-02 (458行目) | ○ |
| C-14 | InstallUtil.proceedToNextStateFrom()で状態遷移 | E-02 (436行目) | ○ |
| C-15 | CRUMBイシュアーからcrumb情報を取得 | E-02 (438-442行目) | ○ |
| C-16 | 関連機能はシステム設定(45)とJenkins本体(1) | E-04 | ○ |
| C-17 | エラーパネルのdivが存在 | E-01 (38行目 `<div class="error-panel error" />`) | ○ |
| C-18 | ヘルプテキストが表示される | E-01 (43行目 `${%jenkinsURL_help}`) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - すべての主要な処理について根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - URL検証ロジックが明確
- 0: 低リスク - 設定の永続化先が明確

## 6) レビュアーチェックリスト（最小）
- [ ] doConfigureInstance()の処理フローが実装と一致するか確認
- [ ] URL検証ロジック（UrlHelper.isValidRootUrl）の挙動が正しく説明されているか確認
- [ ] JenkinsLocationConfigurationへの保存処理が正確か確認
- [ ] setInitialRootUrlFieldValueのJavaScript実装の詳細を補足する必要があるか検討
