---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：54-セキュリティトークン認証

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. 特になし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/jenkins/install/SetupWizard/authenticate-security-token.jelly` (45行)
- E-02: `core/src/main/java/jenkins/install/SetupWizard.java` (152-166行, 308-327行, 688-689行)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (54行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (54行目関連)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フォームのアクションはauthenticationGatewayUrl | E-01 (7行目 `action="${app.instance.securityRealm.authenticationGatewayUrl}"`) | ○ |
| C-02 | j_usernameはhiddenで固定値"admin" | E-01 (29行目 `value="${app.setupWizard.initialSetupAdminUserName}"`) | ○ |
| C-03 | j_passwordのパスワード入力フィールドがある | E-01 (30行目 `id="security-token" type="password" name="j_password"`) | ○ |
| C-04 | タイトルは "Unlock Jenkins" | E-01 (19行目 `${%authenticate-security-token.unlock.jenkins}`) | ○ |
| C-05 | モーダルヘッダーは "Getting Started" | E-01 (15行目 `${%authenticate-security-token.getting.started}`) | ○ |
| C-06 | エラー時にアラートボックスが表示される | E-01 (22-25行目 `<j:if test="${error}">`) | ○ |
| C-07 | エラー時に入力フィールドにdangerクラス適用 | E-01 (27, 30行目 `${error ? 'has-error' : ''}`, `${error ? 'danger' : ''}`) | ○ |
| C-08 | CRUMBトークンがhiddenフィールドで送信される | E-01 (9行目) | ○ |
| C-09 | fromパラメータがhiddenで送信される | E-01 (8行目) | ○ |
| C-10 | レイアウトタイプはfull-screen | E-01 (4行目 `type="full-screen"`) | ○ |
| C-11 | Bootstrap 3スタイルが適用される | E-01 (10行目 `class="plugin-setup-wizard bootstrap-3"`) | ○ |
| C-12 | パスワードファイルの場所が説明される | E-01 (20行目 `${%jenkins.install.findSecurityTokenMessage(it.initialAdminPasswordFile)}`) | ○ |
| C-13 | 初期管理者ユーザー名のデフォルトは"admin" | E-02 (98行目 `initialSetupAdminUserName = "admin"`) | ○ |
| C-14 | パスワードファイルはsecrets/initialAdminPassword | E-02 (689行目) | ○ |
| C-15 | パスワードはUUIDから生成される | E-02 (152行目) | ○ |
| C-16 | パスワードファイルのパーミッションは0640 | E-02 (165行目 `iapf.chmod(0640)`) | ○ |
| C-17 | isUsingSecurityDefaults()でパスワード検証 | E-02 (308-327行目) | ○ |
| C-18 | ユーザー数1かつadminの存在を確認 | E-02 (313-314行目) | ○ |
| C-19 | 関連機能は認証(28)と機密情報管理(34) | E-04 | ○ |
| C-20 | Continueボタンのクラスはbtn btn-primary | E-01 (35行目 `class="btn btn-primary set-security-key"`) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - すべての主要な処理について根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - 認証フローが明確に記述されている
- 0: 低リスク - セキュリティ関連の実装詳細が正確

## 6) レビュアーチェックリスト（最小）
- [ ] 認証ゲートウェイURLの解決が正しいか確認
- [ ] パスワード検証ロジックの説明が実装と一致するか確認
- [ ] エラー表示の条件とスタイル適用が正確か確認
- [ ] CRUMBトークンのCSRF保護が正しく機能するか確認
