---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：56-ログレコーダー一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/hudson/logging/LogRecorderManager/index.jelly` (86行)
- E-02: `core/src/main/java/hudson/logging/LogRecorderManager.java` (314行)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (56行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (56行目関連)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブルIDはlogRecorders | E-01 (63行目 `id="logRecorders"`) | ○ |
| C-02 | テーブルにsortableクラスが付与 | E-01 (63行目 `class="jenkins-table sortable"`) | ○ |
| C-03 | Add recorderボタンが存在 | E-01 (34-37行目) | ○ |
| C-04 | Log levelsボタンが存在 | E-01 (38-40行目 `href="levels"`) | ○ |
| C-05 | ヘルプリンクが外部URLを指す | E-01 (41行目 `href="https://www.jenkins.io/redirect/log-recorders"`) | ○ |
| C-06 | l:settings-subpageレイアウトを使用 | E-01 (51行目) | ○ |
| C-07 | All Jenkins Logsリンクが存在 | E-01 (71行目 `href="all" name="${%All Jenkins Logs}"`) | ○ |
| C-08 | j:forEachでレコーダーをループ | E-01 (72行目 `items="${it.recorders}"`) | ○ |
| C-09 | 設定ボタンにsymbol-settingsアイコン | E-01 (77行目 `src="symbol-settings"`) | ○ |
| C-10 | l:isAdminで権限チェック | E-01 (33, 74行目 `<l:isAdmin>`) | ○ |
| C-11 | doNewLogRecorder()で新規作成 | E-02 (167-177行目) | ○ |
| C-12 | Jenkins.ADMINISTER権限が必要（作成時） | E-02 (169行目) | ○ |
| C-13 | Jenkins.checkGoodName()で名前検証 | E-02 (171行目) | ○ |
| C-14 | 設定画面へのリダイレクト | E-02 (176行目 `return new HttpRedirect(name + "/configure")`) | ○ |
| C-15 | getTarget()でSYSTEM_READ権限チェック | E-02 (296-299行目) | ○ |
| C-16 | configDir()で設定ディレクトリを取得 | E-02 (143-145行目 `new File(Jenkins.get().getRootDir(), "log")`) | ○ |
| C-17 | 関連機能はログ管理(50) | E-04 | ○ |
| C-18 | URL は /log/ | E-02 (131行目 `getSearchUrl() return "/log"`) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - すべての主要な処理について根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - 権限チェックが適切に実装されている
- 0: 低リスク - ファイル保存先が明確

## 6) レビュアーチェックリスト（最小）
- [ ] doNewLogRecorder()の処理フローが正確か確認
- [ ] 権限チェック（SYSTEM_READ/ADMINISTER）が適切か確認
- [ ] ログレコーダーのXMLファイル形式を確認
- [ ] RSSフィード機能の詳細を補足する必要があるか検討
