---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：58-ラベル詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  1. 特になし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/hudson/model/Label/index.jelly` (72行)
- E-02: `core/src/main/java/hudson/model/Label.java` (677行)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (58行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (58行目関連)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sidepanel.jellyをインクルード | E-01 (28行目) | ○ |
| C-02 | l:app-barでタイトル表示 | E-01 (31行目 `title="${it.name}"`) | ○ |
| C-03 | it.atomでアトムラベル判定 | E-01 (32行目 `<j:if test="${it.atom}">`) | ○ |
| C-04 | ADMINISTER権限で説明編集ボタン表示 | E-01 (33行目 `permission="${app.ADMINISTER}"`) | ○ |
| C-05 | Nodesセクションが存在 | E-01 (45行目 `<h2>${%Nodes}</h2>`) | ○ |
| C-06 | getComputers()でノード取得 | E-01 (46行目 `items="${it.computers}"`) | ○ |
| C-07 | Projectsセクションが存在 | E-01 (57行目 `<h2>${%Projects}</h2>`) | ○ |
| C-08 | getTiedJobs()でジョブ取得 | E-01 (58行目 `value="${it.tiedJobs}"`) | ○ |
| C-09 | jobsが空の場合Noneを表示 | E-01 (60-63行目) | ○ |
| C-10 | t:projectViewでジョブ一覧表示 | E-01 (65行目) | ○ |
| C-11 | getNodes()でノードを取得 | E-02 (206-220行目) | ○ |
| C-12 | matches()でノードとラベルを照合 | E-02 (216-217行目) | ○ |
| C-13 | getTiedJobs()でジョブを取得 | E-02 (392-398行目) | ○ |
| C-14 | AbstractProjectのみが対象 | E-02 (394行目 `AbstractProject.class`) | ○ |
| C-15 | getUrl()でURL生成 | E-02 (152-154行目 `"label/" + Util.rawEncode(name) + '/'`) | ○ |
| C-16 | 関連機能はラベル管理(68)、コンピューター管理(12)、ジョブ(4) | E-04 | ○ |
| C-17 | ノードをソートして返却 | E-02 (225行目 `sorted(Comparator.comparing(IComputer::getName))`) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - すべての主要な処理について根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - ラベルの種類による分岐が明確
- 0: 低リスク - データ取得処理が明確

## 6) レビュアーチェックリスト（最小）
- [ ] LabelAtomとLabelExpressionの違いが正確に説明されているか確認
- [ ] getComputers()のソート順が正しいか確認
- [ ] getTiedJobs()のフィルタリング条件が正確か確認
- [ ] 説明編集機能の詳細を補足する必要があるか検討
