---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：59-CLI操作

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/hudson/cli/CLIAction/index.jelly` (83行)
- E-02: `core/src/main/java/hudson/cli/CLIAction.java` (384行)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (59行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (59行目関連)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | l:settings-subpageレイアウトを使用 | E-01 (39行目) | ○ |
| C-02 | permission="${app.READ}"で権限設定 | E-01 (39行目) | ○ |
| C-03 | ヘルプリンクが外部URLを指す | E-01 (30行目 `href="https://www.jenkins.io/redirect/cli"`) | ○ |
| C-04 | f:sectionでGetting started | E-01 (41行目 `title="${%Getting started}"`) | ○ |
| C-05 | jenkins-cli.jarへのダウンロードリンク | E-01 (47行目 `href="${rootURL}/jnlpJars/jenkins-cli.jar"`) | ○ |
| C-06 | f:sectionでAvailable Commands | E-01 (62行目) | ○ |
| C-07 | テーブルにsortableクラス | E-01 (63行目 `class="jenkins-table sortable"`) | ○ |
| C-08 | h.getCLICommands()でコマンド取得 | E-01 (71行目) | ○ |
| C-09 | コマンド詳細リンクはcommand/{name} | E-01 (74行目 `href="command/${command.name}"`) | ○ |
| C-10 | shortDescriptionで説明表示 | E-01 (76行目 `${command.shortDescription}`) | ○ |
| C-11 | doCommand()でコマンド詳細処理 | E-02 (100-114行目) | ○ |
| C-12 | Jenkins.READ権限が必要 | E-02 (102行目 `jenkins.checkPermission(Jenkins.READ)`) | ○ |
| C-13 | CLICommand.clone()でコマンド取得 | E-02 (106行目) | ○ |
| C-14 | コマンドなしで404エラー | E-02 (107-109行目 `SC_NOT_FOUND`) | ○ |
| C-15 | getUrlName()は"cli" | E-02 (97行目 `return "cli"`) | ○ |
| C-16 | getDisplayName()は"Jenkins CLI" | E-02 (92行目 `return "Jenkins CLI"`) | ○ |
| C-17 | isWebSocketSupported()でWS対応チェック | E-02 (117-119行目) | ○ |
| C-18 | 関連機能はCLIコマンド基盤(39)他 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - すべての主要な処理について根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - 権限チェックが適切
- 1: 中リスク - WebSocket対応の詳細は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] doCommand()の処理フローが正確か確認
- [ ] CLICommand.clone()の動作を確認
- [ ] WebSocket接続の実装詳細を補足する必要があるか検討
- [ ] 認証方法（APIトークン、SSH）の説明を追加する必要があるか検討
